/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.networking.impl.client;

import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CommonPacketListenerImplExt;
import eu.pb4.polymer.networking.api.client.PolymerClientNetworking;
import eu.pb4.polymer.networking.api.client.PolymerClientPacketHandler;
import eu.pb4.polymer.networking.impl.ClientPackets;
import eu.pb4.polymer.networking.impl.ExtConnection;
import eu.pb4.polymer.networking.impl.ServerPackets;
import eu.pb4.polymer.networking.impl.packets.DisableS2CPayload;
import eu.pb4.polymer.networking.impl.packets.HandshakePayload;
import eu.pb4.polymer.networking.impl.packets.HelloS2CPayload;
import eu.pb4.polymer.networking.impl.packets.MetadataPayload;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_8673;
import net.minecraft.class_8674;
import net.minecraft.class_8710;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ClientPacketRegistry {
    public static final HashMap<Class<?>, List<PolymerClientPacketHandler<class_8673, ?>>> COMMON_PACKET_LISTENERS = new HashMap();
    public static final HashMap<Class<?>, List<PolymerClientPacketHandler<class_634, ?>>> PLAY_PACKET_LISTENERS = new HashMap();
    public static final HashMap<Class<?>, List<PolymerClientPacketHandler<class_8674, ?>>> CONFIG_PACKET_LISTENERS = new HashMap();
    public static final Object2IntMap<class_2960> CLIENT_PROTOCOL = new Object2IntOpenHashMap();
    public static final Map<class_2960, class_2520> SERVER_METADATA = new HashMap<class_2960, class_2520>();
    public static final Map<class_2960, class_2520> METADATA = new HashMap<class_2960, class_2520>();
    public static String lastVersion;

    public static void register() {
        PolymerClientNetworking.registerCommonHandler(HandshakePayload.class, ClientPacketRegistry::handleHandshake);
        PolymerClientNetworking.registerCommonHandler(MetadataPayload.class, ClientPacketRegistry::handleMetadata);
        PolymerClientNetworking.registerCommonHandler(DisableS2CPayload.class, ClientPacketRegistry::handleDisable);
        PolymerClientNetworking.registerCommonHandler(HelloS2CPayload.class, ClientPacketRegistry::handleHello);
    }

    private static void handleHello(class_310 client, class_8673 handler, HelloS2CPayload payload) {
        ClientPacketRegistry.sendHandshake(handler);
    }

    public static boolean handle(class_310 client, class_8673 handler, class_8710 packet) {
        List<PolymerClientPacketHandler<class_8673, ?>> packetHandlers = COMMON_PACKET_LISTENERS.get(packet.getClass());
        boolean handled = false;
        if (packetHandlers != null) {
            for (PolymerClientPacketHandler<class_8673, ?> pHandler : packetHandlers) {
                pHandler.onPacket(client, handler, packet);
            }
            boolean bl = handled = !packetHandlers.isEmpty();
        }
        if (handler instanceof class_634) {
            class_634 playNetworkHandler = (class_634)handler;
            List<PolymerClientPacketHandler<class_634, ?>> packetHandlers2 = PLAY_PACKET_LISTENERS.get(packet.getClass());
            if (packetHandlers2 != null) {
                for (PolymerClientPacketHandler<class_634, ?> pHandler : packetHandlers2) {
                    pHandler.onPacket(client, playNetworkHandler, packet);
                }
                handled = handled || !packetHandlers2.isEmpty();
            }
        } else if (handler instanceof class_8674) {
            class_8674 networkHandler = (class_8674)handler;
            List<PolymerClientPacketHandler<class_8674, ?>> packetHandlers2 = CONFIG_PACKET_LISTENERS.get(packet.getClass());
            if (packetHandlers2 != null) {
                for (PolymerClientPacketHandler<class_8674, ?> pHandler : packetHandlers2) {
                    pHandler.onPacket(client, networkHandler, packet);
                }
                handled = handled || !packetHandlers2.isEmpty();
            }
        }
        return handled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear(@Nullable class_8673 handler) {
        lastVersion = "";
        CLIENT_PROTOCOL.clear();
        Map<class_2960, class_2520> map = SERVER_METADATA;
        synchronized (map) {
            SERVER_METADATA.clear();
        }
        if (handler != null) {
            ExtConnection ext = (ExtConnection)((CommonPacketListenerImplExt)handler).polymerCommon$getConnection();
            ext.polymerNet$getMetadataMap().clear();
            ext.polymerNet$getSupportMap().clear();
            ext.polymerNet$setVersion("");
        }
        PolymerClientNetworking.AFTER_DISABLE.invoke(Runnable::run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleMetadata(class_310 client, class_8673 handler, MetadataPayload payload) {
        Map<class_2960, class_2520> map = SERVER_METADATA;
        synchronized (map) {
            SERVER_METADATA.clear();
            SERVER_METADATA.putAll(payload.map());
        }
        ExtConnection ext = (ExtConnection)((CommonPacketListenerImplExt)handler).polymerCommon$getConnection();
        ext.polymerNet$getMetadataMap().clear();
        ext.polymerNet$getMetadataMap().putAll(payload.map());
        PolymerClientNetworking.AFTER_METADATA_RECEIVED.invoke(Runnable::run);
    }

    public static void handleHandshake(class_310 client, class_8673 handler, HandshakePayload payload) {
        CLIENT_PROTOCOL.clear();
        SERVER_METADATA.clear();
        lastVersion = payload.version();
        payload.packetVersions().forEach((id, ver) -> CLIENT_PROTOCOL.put(id, ClientPackets.getBestSupported(id, ver)));
        ExtConnection ext = (ExtConnection)((CommonPacketListenerImplExt)handler).polymerCommon$getConnection();
        ext.polymerNet$getSupportMap().putAll(CLIENT_PROTOCOL);
        ext.polymerNet$setVersion(lastVersion);
        PolymerClientNetworking.AFTER_HANDSHAKE_RECEIVED.invoke(Runnable::run);
        ClientPacketRegistry.sendMetadata(handler);
    }

    private static void sendMetadata(class_8673 handler) {
        try {
            PolymerClientNetworking.BEFORE_METADATA_SYNC.invoke(Runnable::run);
            handler.method_52787((class_2596)new class_2817((class_8710)new MetadataPayload(METADATA)));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void handleDisable(class_310 client, class_8673 handler, DisableS2CPayload payload) {
        ClientPacketRegistry.clear(handler);
    }

    public static void sendHandshake(class_8673 handler) {
        handler.method_52787((class_2596)new class_2817((class_8710)new HandshakePayload(CommonImpl.VERSION, ServerPackets.VERSION_REGISTRY)));
    }
}

