package eu.pb4.polymer.networking.api;

import I;
import com.mojang.authlib.GameProfile;
import eu.pb4.polymer.networking.api.server.PolymerServerNetworking;
import eu.pb4.polymer.networking.impl.NetworkHandlerExtension;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_8703;
import net.minecraft.class_8710;
import net.minecraft.class_8791;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.ContextProvidingPacketListener;
import xyz.nucleoid.packettweaker.PacketContext;

public class ContextByteBuf extends class_9129 {
    private final PacketContext context;
    private final int version;

    public static ContextByteBuf of(PacketContext context, int version, ByteBuf buf) {
        class_5455 registryManager = null;

        if (buf instanceof class_9129 reg) {
            registryManager = reg.method_56349();
        } else if (context.getPacketListener() instanceof NetworkHandlerExtension ext) {
            registryManager = ext.polymer$getDynamicRegistryManager();
        }
        if (registryManager == null) {
            registryManager = class_5455.field_40585;
        }

        return new ContextByteBuf(context, version, buf, registryManager);
    }

    public ContextByteBuf(PacketContext context, int version, ByteBuf buf, class_5455 registryManager) {
        super(buf, registryManager);
        this.context = context;
        this.version = version;
    }

    public static <T extends class_8710> class_9139<ByteBuf, T> simple(class_9139<ContextByteBuf, T> codec) {
        return class_9139.method_56437(
                (x, y) -> codec.encode(of(PacketContext.get(), 0, x), y),
                (x) -> codec.decode(of(PacketContext.get(), 0, x)));
    }

    public static <T extends class_8710> class_9139<ByteBuf, T> versioned(class_2960 identifier, class_9139<ContextByteBuf, T> codec) {
        return class_9139.method_56437(
                (x, y) -> {
                    try {
                        var ctx = PacketContext.get();
                        var version = PolymerNetworking.getSupportedVersion(ctx.getClientConnection(), identifier);
                        class_8703.method_53017(x, version);
                        codec.encode(of(ctx, version, x), y);
                    } catch (Throwable e) {
                        e.printStackTrace();
                    }
                },
                (x) -> codec.decode(of(PacketContext.get(), class_8703.method_53016(x), x)));
    }

    public int version() {
        return this.version;
    }

    @Nullable
    public class_3222 player() {
        return context.getPlayer();
    }
    @Nullable
    public class_8791 clientOptions() {
        return context.getClientOptions();
    }
    @Nullable
    public GameProfile gameProfile() {
        return context.getGameProfile();
    }


    public ContextProvidingPacketListener packetListener() {
        return context.getPacketListener();
    }

    @Nullable
    public class_2535 clientConnection() {
        return context.getClientConnection();
    }

    @Nullable
    public class_2596<?> encodedPacket() {
        return context.getEncodedPacket();
    }
}
