package eu.pb4.polymer.networking.api.client;

import eu.pb4.polymer.common.api.events.SimpleEvent;
import eu.pb4.polymer.networking.impl.ClientPackets;
import eu.pb4.polymer.networking.impl.ServerPackets;
import eu.pb4.polymer.networking.impl.client.ClientPacketRegistry;
import eu.pb4.polymer.networking.impl.packets.HandshakePayload;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_4614;
import net.minecraft.class_634;
import net.minecraft.class_8673;
import net.minecraft.class_8674;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;


/**
 * General utilities while dealing with client side integrations
 */
@Environment(EnvType.CLIENT)
public final class PolymerClientNetworking {
    public static final SimpleEvent<Runnable> AFTER_HANDSHAKE_RECEIVED = new SimpleEvent<>();
    public static final SimpleEvent<Runnable> AFTER_METADATA_RECEIVED = new SimpleEvent<>();
    public static final SimpleEvent<Runnable> AFTER_DISABLE = new SimpleEvent<>();
    public static final SimpleEvent<Runnable> BEFORE_METADATA_SYNC = new SimpleEvent<>();

    private PolymerClientNetworking() {
    }

    public static <T extends class_8710> void registerCommonHandler(Class<T> payloadClass, PolymerClientPacketHandler<class_8673, T> handler) {
        ClientPacketRegistry.COMMON_PACKET_LISTENERS.computeIfAbsent(payloadClass, (x) -> new ArrayList<>()).add(handler);
    }

    public static <T extends class_8710> void registerPlayHandler(Class<T> payloadClass, PolymerClientPacketHandler<class_634, T> handler) {
        ClientPacketRegistry.PLAY_PACKET_LISTENERS.computeIfAbsent(payloadClass, (x) -> new ArrayList<>()).add(handler);
    }

    public static <T extends class_8710> void registerConfigurationHandler(Class<T> payloadClass, PolymerClientPacketHandler<class_8674, T> handler) {
        ClientPacketRegistry.CONFIG_PACKET_LISTENERS.computeIfAbsent(payloadClass, (x) -> new ArrayList<>()).add(handler);
    }

    public static int getSupportedVersion(class_2960 identifier) {
        return ClientPacketRegistry.CLIENT_PROTOCOL.getOrDefault(identifier, -1);
    }

    @Nullable
    public static <T extends class_2520> T getMetadata(class_2960 identifier, class_4614<T> type) {
        var x = ClientPacketRegistry.SERVER_METADATA.get(identifier);
        if (x != null && x.method_23258() == type) {
            //noinspection unchecked
            return (T) x;
        }
        return null;
    }

    public static void setClientMetadata(class_2960 identifier, @Nullable class_2520 nbtElement) {
        if (nbtElement == null) {
            ClientPacketRegistry.METADATA.remove(identifier);
        } else {
            ClientPacketRegistry.METADATA.put(identifier, nbtElement);
        }
    }

    public static String getServerVersion() {
        return ClientPacketRegistry.lastVersion;
    }

    public static boolean isEnabled() {
        return ClientPacketRegistry.lastVersion.isEmpty();
    }
}
