package eu.pb4.polymer.networking.api.server;

import I;
import com.mojang.authlib.GameProfile;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.networking.impl.EarlyPlayConnectionMagic;
import eu.pb4.polymer.networking.impl.TempPlayerLoginAttachments;
import net.minecraft.class_1934;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2661;
import net.minecraft.class_2670;
import net.minecraft.class_2678;
import net.minecraft.class_2724;
import net.minecraft.class_2792;
import net.minecraft.class_2793;
import net.minecraft.class_2795;
import net.minecraft.class_2797;
import net.minecraft.class_2799;
import net.minecraft.class_2803;
import net.minecraft.class_2805;
import net.minecraft.class_2811;
import net.minecraft.class_2813;
import net.minecraft.class_2815;
import net.minecraft.class_2817;
import net.minecraft.class_2820;
import net.minecraft.class_2822;
import net.minecraft.class_2824;
import net.minecraft.class_2827;
import net.minecraft.class_2828;
import net.minecraft.class_2833;
import net.minecraft.class_2836;
import net.minecraft.class_2838;
import net.minecraft.class_2840;
import net.minecraft.class_2842;
import net.minecraft.class_2846;
import net.minecraft.class_2848;
import net.minecraft.class_2851;
import net.minecraft.class_2853;
import net.minecraft.class_2855;
import net.minecraft.class_2856;
import net.minecraft.class_2859;
import net.minecraft.class_2863;
import net.minecraft.class_2866;
import net.minecraft.class_2868;
import net.minecraft.class_2870;
import net.minecraft.class_2871;
import net.minecraft.class_2873;
import net.minecraft.class_2875;
import net.minecraft.class_2877;
import net.minecraft.class_2879;
import net.minecraft.class_2884;
import net.minecraft.class_2885;
import net.minecraft.class_2886;
import net.minecraft.class_2935;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3753;
import net.minecraft.class_4210;
import net.minecraft.class_4211;
import net.minecraft.class_5194;
import net.minecraft.class_5427;
import net.minecraft.class_6373;
import net.minecraft.class_6374;
import net.minecraft.class_7472;
import net.minecraft.class_7633;
import net.minecraft.class_7640;
import net.minecraft.class_7861;
import net.minecraft.class_8589;
import net.minecraft.class_8590;
import net.minecraft.class_8591;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import net.minecraft.class_8791;
import net.minecraft.class_8875;
import net.minecraft.class_9091;
import net.minecraft.class_9095;
import net.minecraft.class_9129;
import net.minecraft.class_9179;
import net.minecraft.class_9449;
import net.minecraft.class_9812;
import net.minecraft.network.packet.c2s.common.*;
import net.minecraft.network.packet.c2s.play.*;
import net.minecraft.network.packet.s2c.play.*;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.ContextProvidingPacketListener;

import java.util.Optional;
import java.util.function.Function;

/**
 * This api exposes Polymer's early play packets utilities.
 *
 * Use carefully, as client might not be initialized, or it might have leftover state from previous EarlyPlay handlers
 * Use this only if you know what you are doing and you need to do sync/packets before player joins a world.
 */

public class EarlyPlayNetworkHandler implements class_2792, class_7633, ContextProvidingPacketListener {

    public static void register(Function<Context, EarlyPlayNetworkHandler> constructor) {
        EarlyPlayConnectionMagic.register(constructor);
    }

    private final EarlyPlayConnectionMagic.ContextImpl context;
    private final class_2960 identifier;

    private volatile long lastResponse = 0;

    private volatile int keepAliveSent = 0;
    private volatile int keepAliveReceived = 0;
    private volatile int pingsId = 1024;
    private volatile boolean canContinue = true;
    private volatile boolean alreadyContinued;

    public EarlyPlayNetworkHandler(class_2960 identifier, Context context) {
        this.context = (EarlyPlayConnectionMagic.ContextImpl) context;
        this.identifier = identifier;

        this.context.connection().method_56330(class_9095.field_48172.method_61107(class_9129.method_56350(this.getServer().method_30611())),
                this);

        this.sendKeepAlive();
    }

    public final class_2960 getId() {
        return this.identifier;
    }

    public void handleDisconnect(class_9812 reason) {

    }

    public void handleKeepAlive(long time) {

    }

    public boolean handleCustomPayload(class_2817 packet) {
        return false;
    }

    @Override
    public final void method_18784() {
        if (this.lastResponse++ == 1200) {
            this.disconnect(class_2561.method_43471("multiplayer.disconnect.slow_login"));
        } else if (this.lastResponse == 20) {
            this.sendKeepAlive();
        }

        this.onTick();
    }

    protected void onTick() {
    }

    protected void forceRespawnPacket() {
        ((TempPlayerLoginAttachments) this.getPlayer()).polymerNet$setForceRespawnPacket();
    }

    protected boolean isForcingRespawnPacket() {
        return ((TempPlayerLoginAttachments) this.getPlayer()).polymerNet$getForceRespawnPacket();
    }

    @Override
    public final void method_52393(class_2827 packet) {
        this.lastResponse = -20;
        this.keepAliveReceived++;
        if (this.canContinue) {
            this.handleKeepAlive(packet.method_12267());
        } else if (!this.alreadyContinued && this.keepAliveReceived >= this.keepAliveSent) {
            this.alreadyContinued = true;
            this.context.server().execute(() -> this.context.continueRunning().accept(this.context));
        }
    }

    @Override
    public void method_52394(class_6374 packet) {

    }

    public final void sendPacket(class_2596<?> packet) {
        this.context.connection().method_10743(packet);
        if (packet instanceof class_2678 packet1) {
            if (this.isForcingRespawnPacket()) {
                this.context.connection().method_10743(new class_2724(packet1.comp_1727(), class_2724.field_41732));
            }

            this.forceRespawnPacket();
        }
    }

    protected void sendPacket(class_8710 payload) {
        this.sendPacket(new class_2658(payload));
    }

    public final void sendKeepAlive(long value) {
        this.keepAliveSent++;
        this.sendPacket(new class_2670(value));
    }

    public final void sendKeepAlive() {
        this.sendKeepAlive(System.currentTimeMillis());
    }

    public final void sendPing(int id) {
        this.sendPacket(new class_6373(id));
    }

    public final int sendPing() {
        var id = this.pingsId++;
        this.sendPing(id);
        return id;
    }

    @Override
    public final void method_52392(class_2817 packet) {
        if (!handleCustomPayload(packet)) {
            this.context.storedPackets().add(packet);
        }
    }

    @Override
    public void method_52395(class_2856 packet) {

    }

    @Override
    public void method_12069(class_2803 packet) {
        try {
            this.getPlayer().method_14213(packet.comp_1963());
        } catch (Throwable e) {
            // Ignore
        }

        this.context.options().setValue(packet.comp_1963());
    }

    public final void sendInitialGameJoin() {
        if (!this.isForcingRespawnPacket()) {
            var player = this.getPlayer();
            var world = this.getServer().method_30002();
            this.sendPacket(new class_2678(player.method_5628(), false, this.getServer().method_29435(), 0, 2, 2,
                    true, false, true, new class_8589(
                    world.method_40134(),
                    world.method_27983(),
                    0,
                    class_1934.field_9216,
                    class_1934.field_9216,
                    false,
                    true,
                    Optional.empty(),
                    0
            ), this.getServer().method_43500()));
        }
    }

    public final class_2535 getConnection() {
        return this.context.connection();
    }

    public final void disconnect(class_2561 reason) {
        try {
            CommonImpl.LOGGER.info("Disconnecting {} on {}: {}", this.getConnectionInfo(), this.getId(), reason.getString());
            this.sendPacket(new class_2661(reason));
            this.context.connection().method_10747(reason);
            this.context.storedPackets().clear();
        } catch (Exception var3) {
            CommonImpl.LOGGER.error("Error whilst disconnecting player", var3);
        }

    }

    public final MinecraftServer getServer() {
        return this.context.server();
    }

    public final void continueJoining() {
        if (this.canContinue) {
            this.canContinue = false;
            this.sendKeepAlive();
        }
    }

    public final class_3222 getPlayer() {
        return this.context.player();
    }

    public final String getConnectionInfo() {
        if (this.getPlayer().method_7334() != null) {
            GameProfile var10000 = this.getPlayer().method_7334() ;
            return "" + var10000 + " (" + this.context.connection().method_10755() + ")";
        } else {
            return String.valueOf(this.context.connection().method_10755());
        }
    }

    @Override
    public void method_12052(class_2879 packet) {

    }

    @Override
    public void method_12048(class_2797 packet) {

    }

    @Override
    public void method_43667(class_7472 packet) {

    }

    @Override
    public void method_58580(class_9449 packet) {

    }

    @Override
    public void method_44898(class_7640 packet) {

    }

    @Override
    public void method_12068(class_2799 packet) {

    }

    @Override
    public void method_12055(class_2811 packet) {

    }

    @Override
    public void method_12076(class_2813 packet) {

    }

    @Override
    public void method_12061(class_2840 packet) {

    }

    @Override
    public void method_12054(class_2815 packet) {

    }

    @Override
    public void method_12062(class_2824 packet) {

    }

    @Override
    public void method_12063(class_2828 packet) {

    }


    @Override
    public void method_12083(class_2842 packet) {

    }

    @Override
    public void method_12066(class_2846 packet) {

    }

    @Override
    public void method_12045(class_2848 packet) {

    }

    @Override
    public void method_12067(class_2851 packet) {

    }

    @Override
    public void method_12056(class_2868 packet) {

    }

    @Override
    public void method_12070(class_2873 packet) {

    }

    @Override
    public void method_12071(class_2877 packet) {

    }

    @Override
    public void method_12046(class_2885 packet) {

    }

    @Override
    public void method_12065(class_2886 packet) {

    }

    @Override
    public void method_12073(class_2884 packet) {

    }

    @Override
    public void method_12064(class_2836 packet) {

    }

    @Override
    public void method_12078(class_2833 packet) {

    }

    @Override
    public void method_12050(class_2793 packet) {

    }

    @Override
    public void method_12047(class_2853 packet) {

    }

    @Override
    public void method_30303(class_5427 packet) {

    }

    @Override
    public void method_12058(class_2859 packet) {

    }

    @Override
    public void method_12059(class_2805 packet) {

    }

    @Override
    public void method_12077(class_2870 packet) {

    }

    @Override
    public void method_12049(class_2871 packet) {

    }

    @Override
    public void method_12084(class_2838 packet) {

    }

    @Override
    public void method_12060(class_2855 packet) {

    }

    @Override
    public void method_12057(class_2866 packet) {

    }

    @Override
    public void method_12051(class_2875 packet) {

    }

    @Override
    public void method_12080(class_2863 packet) {

    }

    @Override
    public void method_12053(class_2820 packet) {

    }

    @Override
    public void method_12074(class_2822 packet) {

    }

    @Override
    public void method_54436(class_8875 packet) {

    }

    @Override
    public void method_12072(class_2795 packet) {

    }

    @Override
    public void method_16383(class_3753 packet) {

    }

    @Override
    public void method_27273(class_5194 packet) {

    }

    @Override
    public void method_19475(class_4210 packet) {

    }

    @Override
    public void method_19476(class_4211 packet) {

    }

    @Override
    public void method_46367(class_7861 packet) {

    }

    @Override
    public void method_52279(class_8591 packet) {

    }

    @Override
    public void method_52278(class_8590 packet) {

    }

    @Override
    public void method_56619(class_9179 packet) {

    }

    @Override
    public void method_10839(class_9812 info) {
        this.context.storedPackets().clear();
        this.handleDisconnect(info);
    }

    @Override
    public boolean method_48106() {
        return this.getConnection().method_10758();
    }

    @Override
    public void method_12697(class_2935 packet) {

    }

    @Override
    public void method_55851(class_9091 packet) {

    }

    @ApiStatus.NonExtendable
    public interface Context {
        MinecraftServer server();
        class_3222 player();
    }

    @Override
    public final @Nullable class_3222 getPlayerForPacketTweaker() {
        return this.getPlayer();
    }


    @Override
    public GameProfile getGameProfileForPacketTweaker() {
        return this.getPlayer().method_7334();
    }

    @Override
    public class_8791 getClientOptionsForPacketTweaker() {
        return this.context.options().getValue();
    }

    protected final class_8610 getConfigurationNetworkHandler() {
        return this.context.loginHandler();
    }
}
