package eu.pb4.polymer.networking.impl;


import ;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.jetbrains.annotations.ApiStatus;

import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import net.minecraft.class_2960;
import net.minecraft.class_9139;

@ApiStatus.Internal
public class ServerPackets {
    public static final HashMap<class_2960, class_9139<ByteBuf, ?>> PAYLOAD_CODEC = new HashMap<>();
    public static final Map<class_2960, int[]> VERSION_REGISTRY = new HashMap<>();
    public static final Object2IntOpenHashMap<class_2960> LATEST = new Object2IntOpenHashMap<>();

    public static int getBestSupported(class_2960 identifier, int[] ver) {

        var values = VERSION_REGISTRY.get(identifier);

        if (values != null) {
            var verSet = new IntArraySet(ver);

            var value = IntStream.of(values).filter(verSet::contains).max();

            return value.isPresent() ? value.getAsInt() : -1;
        }

        return -1;
    }

    public static void register(class_2960 id, class_9139<ByteBuf, ?> codec, int... ver) {
        VERSION_REGISTRY.put(id, ver);
        PAYLOAD_CODEC.put(id, codec);
        LATEST.put(id, getBestSupported(id, ver));
    }
}
