package eu.pb4.polymer.networking.mixin;

import eu.pb4.polymer.common.impl.client.ClientUtils;
import eu.pb4.polymer.networking.api.server.PolymerHandshakeHandler;
import eu.pb4.polymer.networking.api.server.PolymerServerNetworking;
import eu.pb4.polymer.networking.impl.TempPlayerLoginAttachments;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2535;
import net.minecraft.class_2724;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_8792;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3324.class)
public class PlayerManagerMixin {
    @Inject(method = "onPlayerConnect", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/packet/s2c/play/DifficultyS2CPacket;<init>(Lnet/minecraft/world/Difficulty;Z)V", shift = At.Shift.AFTER))
    private void polymerNet$setupHandler(class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
        var handshake = ((TempPlayerLoginAttachments) player).polymerNet$getAndRemoveHandshakeHandler();

        if (handshake != null) {
            handshake.apply(player.field_13987);

        }
        PolymerServerNetworking.ON_PLAY_SYNC.invoke(x -> x.accept(player.field_13987, handshake));

        if (((TempPlayerLoginAttachments) player).polymerNet$getForceRespawnPacket()) {
            var world = player.method_51469();
            connection.method_10743(new class_2724(player.method_52374(world), class_2724.field_41732));
        }
    }

    @Environment(EnvType.CLIENT)
    @Inject(method = "onPlayerConnect", at = @At("HEAD"))
    private void polymerNet$storePlayer(class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
        if (player.field_13995.method_19466(player.method_7334())) {
            ClientUtils.backupPlayer = player;
        }
    }

    @Environment(EnvType.CLIENT)
    @Inject(method = "onPlayerConnect", at = @At("TAIL"))
    private void polymerNet$removePlayer(class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
        if (player.field_13995.method_19466(player.method_7334())) {
            ClientUtils.backupPlayer = null;
        }
    }
}
