/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.networking.api.server;

import eu.pb4.polymer.common.api.events.SimpleEvent;
import eu.pb4.polymer.networking.api.server.PolymerHandshakeHandler;
import eu.pb4.polymer.networking.api.server.PolymerServerPacketHandler;
import eu.pb4.polymer.networking.impl.ExtClientConnection;
import eu.pb4.polymer.networking.impl.NetworkHandlerExtension;
import eu.pb4.polymer.networking.impl.ServerPacketRegistry;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.class_4614;
import net.minecraft.class_8609;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public final class PolymerServerNetworking {
    public static final SimpleEvent<BiConsumer<class_3244, PolymerHandshakeHandler>> ON_PLAY_SYNC = new SimpleEvent();

    private PolymerServerNetworking() {
    }

    public static boolean send(class_3244 handler, class_8710 payload) {
        handler.method_14364((class_2596)new class_2658(payload));
        return true;
    }

    @Nullable
    public static <T extends class_2520> T getMetadata(class_8609 handler, class_2960 identifier, class_4614<T> type) {
        class_2520 x = (class_2520)ExtClientConnection.of(handler).polymerNet$getMetadataMap().get((Object)identifier);
        if (x != null && x.method_23258() == type) {
            return (T)x;
        }
        return null;
    }

    public static void setServerMetadata(class_2960 identifier, @Nullable class_2520 nbtElement) {
        if (nbtElement == null) {
            ServerPacketRegistry.METADATA.remove(identifier);
        } else {
            ServerPacketRegistry.METADATA.put(identifier, nbtElement);
        }
    }

    public static <T extends class_8710> void registerCommonHandler(Class<T> payloadClass, PolymerServerPacketHandler<class_8609, T> handler) {
        ServerPacketRegistry.COMMON_PACKET_LISTENERS.computeIfAbsent(payloadClass, x -> new ArrayList()).add(handler);
    }

    public static <T extends class_8710> void registerPlayHandler(Class<T> payloadClass, PolymerServerPacketHandler<class_3244, T> handler) {
        ServerPacketRegistry.PLAY_PACKET_LISTENERS.computeIfAbsent(payloadClass, x -> new ArrayList()).add(handler);
    }

    public static <T extends class_8710> void registerConfigurationHandler(Class<T> payloadClass, PolymerServerPacketHandler<class_8610, T> handler) {
        ServerPacketRegistry.CONFIG_PACKET_LISTENERS.computeIfAbsent(payloadClass, x -> new ArrayList()).add(handler);
    }

    public static int getSupportedVersion(class_3244 handler, class_2960 serverPacket) {
        return ExtClientConnection.of((class_8609)handler).polymerNet$getSupportedVersion(serverPacket);
    }

    public static long getLastPacketReceivedTime(class_3244 handler, class_2960 identifier) {
        return ((NetworkHandlerExtension)handler).polymerNet$lastPacketUpdate(identifier);
    }
}

