package eu.pb4.polymer.rsm.api;

import eu.pb4.polymer.rsm.impl.QuiltRegistryUtils;
import eu.pb4.polymer.rsm.impl.RegistrySyncExtension;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public final class RegistrySyncUtils {
    private RegistrySyncUtils() {}

    public static <T> boolean isServerEntry(class_2378<T> registry, T entry) {
        if (QuiltRegistryUtils.isOptional(registry, entry)) {
            return true;
        }

        if (registry instanceof RegistrySyncExtension<?>) {
            return ((RegistrySyncExtension<T>) registry).polymer_registry_sync$isServerEntry(entry);
        } else {
            return false;
        }
    }

    public static <T> boolean isServerEntry(class_2378<T> registry, class_2960 identifier) {
        return registry.method_10250(identifier) ? isServerEntry(registry, registry.method_10223(identifier)) : false;
    }

    public static <T> void setServerEntry(class_2378<T> registry, T entry) {
        if (registry instanceof RegistrySyncExtension<?>) {
            ((RegistrySyncExtension<T>) registry).polymer_registry_sync$setServerEntry(entry, true);
            QuiltRegistryUtils.markAsOptional(registry, entry);
        }
    }

    public static <T> void setServerEntry(class_2378<T> registry, class_2960 identifier) {
        if (registry.method_10250(identifier)) {
            setServerEntry(registry, registry.method_10223(identifier));
        } else {
            throw new IllegalArgumentException("Entry '" + identifier + "' of registry '" + registry.method_30517().method_29177() + "' isn't registered!");
        }
    }
}
