package eu.pb4.polymer.resourcepack.extras.api.format.model;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.polymer.common.impl.SortedMapCodec;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5699;

public record ModelElement(class_243 from, class_243 to, Map<class_2350, Face> faces, Optional<Rotation> rotation,
                           boolean shade, int lightEmission) {
    public static final Codec<ModelElement> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            class_243.field_38277.fieldOf("from").forGetter(ModelElement::from),
            class_243.field_38277.fieldOf("to").forGetter(ModelElement::to),
            SortedMapCodec.of(class_2350.field_29502, Face.CODEC).optionalFieldOf("faces", Map.of()).forGetter(ModelElement::faces),
            Rotation.CODEC.optionalFieldOf("rotation").forGetter(ModelElement::rotation),
            Codec.BOOL.optionalFieldOf("shade", true).forGetter(ModelElement::shade),
            class_5699.method_48766(0, 15).optionalFieldOf("light_emission", 0).forGetter(ModelElement::lightEmission)
    ).apply(instance, ModelElement::new));

    public ModelElement(class_243 from, class_243 to, Map<class_2350, Face> faces, Optional<Rotation> rotation,
                        boolean shade) {
        this(from, to, faces, rotation, shade, 0);
    }
    public ModelElement(class_243 from, class_243 to, Map<class_2350, Face> faces, Optional<Rotation> rotation) {
        this(from, to, faces, rotation, true, 0);
    }

    public ModelElement(class_243 from, class_243 to, Map<class_2350, Face> faces) {
        this(from, to, faces, Optional.empty(), true, 0);
    }

    public record Rotation(class_243 origin, class_2350.class_2351 axis, float angle, boolean rescale) {
        public static final Codec<Rotation> CODEC = RecordCodecBuilder.create(instance -> instance.group(
                class_243.field_38277.optionalFieldOf("origin", class_243.field_1353).forGetter(Rotation::origin),
                class_2350.class_2351.field_25065.fieldOf("axis").forGetter(Rotation::axis),
                Codec.FLOAT.fieldOf("angle").forGetter(Rotation::angle),
                Codec.BOOL.optionalFieldOf("rescale", false).forGetter(Rotation::rescale)
        ).apply(instance, Rotation::new));

        public Rotation(class_243 origin, class_2350.class_2351 axis, float angle) {
            this(origin, axis, angle, false);
        }

        public Rotation(class_2350.class_2351 axis, float angle) {
            this(class_243.field_1353, axis, angle, false);
        }
    }

    public record Face(List<Float> uv, String texture, Optional<class_2350> cullface, int rotation, int tintIndex) {
        public static final Codec<Face> CODEC = RecordCodecBuilder.create(instance -> instance.group(
                Codec.list(Codec.FLOAT, 4, 4).optionalFieldOf("uv", List.of()).forGetter(Face::uv),
                Codec.STRING.optionalFieldOf("texture", "").forGetter(Face::texture),
                class_2350.field_29502.optionalFieldOf("cullface").forGetter(Face::cullface),
                Codec.INT.optionalFieldOf("rotation", 0).forGetter(Face::rotation),
                Codec.INT.optionalFieldOf("tintindex", -1).forGetter(Face::tintIndex)
        ).apply(instance, Face::new));

        public Face {
            if (uv.size() != 4 && !uv.isEmpty()) {
                throw new IllegalArgumentException("uv needs to have either 4 elements or be empty");
            }
        }

        public Face(List<Float> uv, String texture, Optional<class_2350> cullface, int rotation) {
            this(uv, texture, cullface, rotation, -1);
        }

        public Face(List<Float> uv, String texture, Optional<class_2350> cullface) {
            this(uv, texture, cullface, 0, -1);
        }

        public Face(List<Float> uv, String texture) {
            this(uv, texture, Optional.empty(), 0, -1);
        }

        public Face(String texture) {
            this(List.of(), texture, Optional.empty(), 0, -1);
        }
    }

    public static Builder builder(class_243 from, class_243 to) {
        return new Builder(from, to);
    }

    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    public static class Builder {
        private final class_243 from;
        private final class_243 to;
        private final Map<class_2350, Face> faces = new EnumMap<>(class_2350.class);
        private Optional<Rotation> rotation = Optional.empty();
        private boolean shade = true;
        private int lightEmission = 0;

        private Builder(class_243 from, class_243 to) {
            this.from = from;
            this.to = to;
        }

        public Builder rotation(class_243 origin, class_2350.class_2351 axis, float angle, boolean rescale) {
            return this.rotation(new Rotation(origin, axis, angle, rescale));
        }

        public Builder rotation(class_243 origin, class_2350.class_2351 axis, float angle) {
            return this.rotation(new Rotation(origin, axis, angle));
        }

        public Builder rotation(class_2350.class_2351 axis, float angle) {
            return this.rotation(new Rotation(axis, angle));
        }

        public Builder face(class_2350 direction, Face face) {
            this.faces.put(direction, face);
            return this;
        }

        public Builder face(class_2350 direction, float u1, float v1, float u2, float v2, String texture, class_2350 cullFace, int rotation, int tint) {
            return this.face(direction, new Face(FloatList.of(u1, v1, u2, v2), texture, Optional.ofNullable(cullFace), rotation, tint));
        }

        public Builder face(class_2350 direction, float u1, float v1, float u2, float v2, String texture, class_2350 cullFace, int rotation) {
            return this.face(direction, new Face(FloatList.of(u1, v1, u2, v2), texture, Optional.ofNullable(cullFace), rotation));
        }

        public Builder face(class_2350 direction, float u1, float v1, float u2, float v2, String texture, class_2350 cullFace) {
            return this.face(direction, new Face(FloatList.of(u1, v1, u2, v2), texture, Optional.ofNullable(cullFace)));
        }

        public Builder face(class_2350 direction, float u1, float v1, float u2, float v2, String texture) {
            return this.face(direction, new Face(FloatList.of(u1, v1, u2, v2), texture));
        }

        public Builder face(class_2350 direction, String texture, class_2350 cullFace, int rotation, int tint) {
            return this.face(direction, new Face(List.of(), texture, Optional.ofNullable(cullFace), rotation, tint));
        }

        public Builder face(class_2350 direction, String texture, int rotation, int tint) {
            return this.face(direction, new Face(List.of(), texture, Optional.empty(), rotation, tint));
        }

        public Builder face(class_2350 direction, String texture, int rotation) {
            return this.face(direction, new Face(List.of(), texture, Optional.empty(), rotation));
        }

        public Builder face(class_2350 direction, String texture) {
            return this.face(direction, new Face(texture));
        }

        public Builder rotation(Rotation rotation) {
            this.rotation = Optional.ofNullable(rotation);
            return this;
        }

        public Builder shade(boolean shade) {
            this.shade = shade;
            return this;
        }

        public Builder lightEmission(int lightEmission) {
            this.lightEmission = class_3532.method_15340(lightEmission, 0, 15);
            return this;
        }


        public ModelElement build() {
            return new ModelElement(from, to, new EnumMap<>(this.faces), this.rotation, this.shade, this.lightEmission);
        }
    }
}
