package eu.pb4.polymer.resourcepack.extras.api.format.font;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_5699;

public record TTFProvider(class_2960 file, float oversample, float size, Shift shift,
                          List<String> skip) implements FontProvider {
    public static final MapCodec<TTFProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            class_2960.field_25139.fieldOf("file").forGetter(TTFProvider::file),
            Codec.FLOAT.optionalFieldOf("oversample", 1f).forGetter(TTFProvider::oversample),
            Codec.FLOAT.optionalFieldOf("size", 11f).forGetter(TTFProvider::size),
            Shift.CODEC.optionalFieldOf("shift", Shift.NONE).forGetter(TTFProvider::shift),
            class_5699.method_65313(Codec.STRING).optionalFieldOf("skip", List.of("")).forGetter(TTFProvider::skip)
    ).apply(instance, TTFProvider::new));

    public TTFProvider(class_2960 file) {
        this(file, 1, 11, Shift.NONE, List.of());
    }

    @Override
    public MapCodec<? extends FontProvider> codec() {
        return CODEC;
    }

    public record Shift(float x, float y) {
        public static final Shift NONE = new Shift(0.0F, 0.0F);
        public static final Codec<Shift> CODEC = Codec.floatRange(-512.0F, 512.0F).listOf().comapFlatMap((floatList) -> {
            return class_156.method_33141(floatList, 2).map((floatListx) -> {
                return new Shift(floatListx.get(0), floatListx.get(1));
            });
        }, (shift) -> {
            return List.of(shift.x, shift.y);
        });
    }
}
