/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.extras.api.format.item.model;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.ItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.property.numeric.NumericProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public record RangeDispatchItemModel(NumericProperty property, float scale, List<Entry> entries, Optional<ItemModel> fallback) implements ItemModel
{
    public static final MapCodec<RangeDispatchItemModel> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NumericProperty.CODEC.forGetter(RangeDispatchItemModel::property), (App)Codec.FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(1.0f)).forGetter(RangeDispatchItemModel::scale), (App)Entry.CODEC.listOf().fieldOf("entries").forGetter(RangeDispatchItemModel::entries), (App)ItemModel.CODEC.optionalFieldOf("fallback").forGetter(RangeDispatchItemModel::fallback)).apply((Applicative)instance, RangeDispatchItemModel::new));

    @Override
    public MapCodec<? extends ItemModel> codec() {
        return CODEC;
    }

    public static Builder builder(NumericProperty property) {
        return new Builder(property);
    }

    @Override
    public ItemModel replaceChildren(ItemModel.Replacer replacer) {
        ArrayList<Entry> list = new ArrayList<Entry>(this.entries.size());
        for (Entry entry : this.entries) {
            ItemModel model2 = replacer.modifyDeep(this, entry.model);
            if (entry.model != model2) {
                list.add(new Entry(entry.threshold, model2));
                continue;
            }
            list.add(entry);
        }
        return new RangeDispatchItemModel(this.property, this.scale, list, this.fallback.map(model -> replacer.modifyDeep(this, (ItemModel)model)));
    }

    public static class Builder {
        private final NumericProperty property;
        private final List<Entry> entries = new ArrayList<Entry>();
        private float scale = 1.0f;
        private Optional<ItemModel> fallbackModel = Optional.empty();

        private Builder(NumericProperty property) {
            this.property = property;
        }

        public Builder scale(float scale) {
            this.scale = scale;
            return this;
        }

        public Builder entry(float threshold, ItemModel model) {
            this.entries.add(new Entry(threshold, model));
            return this;
        }

        public Builder fallback(ItemModel model) {
            this.fallbackModel = Optional.ofNullable(model);
            return this;
        }

        public RangeDispatchItemModel build() {
            return new RangeDispatchItemModel(this.property, this.scale, new ArrayList<Entry>(this.entries), this.fallbackModel);
        }
    }

    public record Entry(float threshold, ItemModel model) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("threshold").forGetter(Entry::threshold), (App)ItemModel.CODEC.fieldOf("model").forGetter(Entry::model)).apply((Applicative)instance, Entry::new));
    }
}

