/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.extras.api.format.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.polymer.common.impl.SortedMapCodec;
import eu.pb4.polymer.resourcepack.api.WritableAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.model.GuiLight;
import eu.pb4.polymer.resourcepack.extras.api.format.model.ModelElement;
import eu.pb4.polymer.resourcepack.extras.api.format.model.ModelTransformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_811;

public record ModelAsset(Optional<class_2960> parent, Optional<List<ModelElement>> elements, Map<String, String> textures, Map<class_811, ModelTransformation> display, Optional<GuiLight> guiLight, boolean ambientOcclusion) implements WritableAsset.Json
{
    public static final Codec<ModelAsset> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("parent").forGetter(ModelAsset::parent), (App)ModelElement.CODEC.listOf().optionalFieldOf("elements").forGetter(ModelAsset::elements), (App)SortedMapCodec.of((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("textures", Map.of()).forGetter(ModelAsset::textures), (App)SortedMapCodec.of((Codec)class_811.field_42468, ModelTransformation.CODEC).optionalFieldOf("display", Map.of()).forGetter(ModelAsset::display), (App)GuiLight.CODEC.optionalFieldOf("gui_light").forGetter(ModelAsset::guiLight), (App)Codec.BOOL.optionalFieldOf("ambientocclusion", (Object)true).forGetter(ModelAsset::ambientOcclusion)).apply((Applicative)instance, ModelAsset::new));

    public ModelAsset(Optional<class_2960> parent, Optional<List<ModelElement>> elements, Map<String, String> textures, Map<class_811, ModelTransformation> display, Optional<GuiLight> guiLight) {
        this(parent, elements, textures, display, guiLight, true);
    }

    public ModelAsset(Optional<class_2960> parent, Optional<List<ModelElement>> elements, Map<String, String> textures, Map<class_811, ModelTransformation> display) {
        this(parent, elements, textures, display, Optional.empty(), true);
    }

    public ModelAsset(Optional<class_2960> parent, Optional<List<ModelElement>> elements, Map<String, String> textures) {
        this(parent, elements, textures, Map.of(), Optional.empty(), true);
    }

    public ModelAsset(class_2960 parent, Map<String, String> textures) {
        this(Optional.of(parent), Optional.empty(), textures, Map.of(), Optional.empty(), true);
    }

    public ModelAsset(List<ModelElement> elements, Map<String, String> textures) {
        this(Optional.empty(), Optional.of(elements), textures, Map.of(), Optional.empty(), true);
    }

    public String toJson() {
        return ((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow()).toString();
    }

    public static ModelAsset fromJson(String json) {
        return (ModelAsset)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)json)).getOrThrow()).getFirst();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Optional<class_2960> parent = Optional.empty();
        private Optional<List<ModelElement>> elements = Optional.empty();
        private final Map<String, String> textures = new HashMap<String, String>();
        private final Map<class_811, ModelTransformation> display = new HashMap<class_811, ModelTransformation>();
        private Optional<GuiLight> guiLight = Optional.empty();
        private boolean ambientOcclusion = true;

        private Builder() {
        }

        public Builder parent(class_2960 parent) {
            this.parent = Optional.ofNullable(parent);
            return this;
        }

        public Builder transformation(class_811 context, ModelTransformation transformation) {
            this.display.put(context, transformation);
            return this;
        }

        public Builder withElements() {
            if (this.elements.isEmpty()) {
                this.elements = Optional.of(new ArrayList());
            }
            return this;
        }

        public Builder withElements(List<ModelElement> elements) {
            this.elements = Optional.ofNullable(elements);
            return this;
        }

        public Builder element(ModelElement element) {
            this.withElements();
            this.elements.get().add(element);
            return this;
        }

        public Builder elements(Collection<ModelElement> element) {
            this.withElements();
            this.elements.get().addAll(element);
            return this;
        }

        public Builder element(class_243 from, class_243 to, Consumer<ModelElement.Builder> builderConsumer) {
            ModelElement.Builder builder = ModelElement.builder(from, to);
            builderConsumer.accept(builder);
            return this.element(builder.build());
        }

        public Builder texture(String key, String value) {
            this.textures.put(key, value);
            return this;
        }

        public Builder texture(Map<String, String> textures) {
            this.textures.putAll(textures);
            return this;
        }

        public Builder guiLight(GuiLight guiLight) {
            this.guiLight = Optional.ofNullable(guiLight);
            return this;
        }

        public Builder ambientOcclusion(boolean ambientOcclusion) {
            this.ambientOcclusion = ambientOcclusion;
            return this;
        }

        public ModelAsset build() {
            return new ModelAsset(this.parent, this.elements.map(ArrayList::new), new HashMap<String, String>(this.textures), new HashMap<class_811, ModelTransformation>(this.display), this.guiLight, this.ambientOcclusion);
        }
    }
}

