/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.extras.api;

import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.api.ResourcePackCreator;
import eu.pb4.polymer.resourcepack.extras.api.format.item.ItemAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.BasicItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.tint.CustomModelDataTintSource;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class ResourcePackExtras {
    private static final ResourcePackExtras MAIN = new ResourcePackExtras(PolymerResourcePackUtils.getInstance());
    private final Map<class_2960, BiFunction<class_2960, ResourcePackBuilder, @Nullable ItemAsset>> bridgedModels = new HashMap<class_2960, BiFunction<class_2960, ResourcePackBuilder, ItemAsset>>();

    ResourcePackExtras(ResourcePackCreator creator) {
        creator.afterInitialCreationEvent.register(this::setup);
    }

    public static ResourcePackExtras forDefault() {
        return MAIN;
    }

    public static ResourcePackExtras of(ResourcePackCreator creator) {
        if (PolymerResourcePackUtils.getInstance() == creator) {
            return MAIN;
        }
        return new ResourcePackExtras(creator);
    }

    public static ResourcePackExtras of(ResourcePackCreator creator, ResourcePackExtras source) {
        if (PolymerResourcePackUtils.getInstance() == creator) {
            throw new IllegalArgumentException("Passed creator matches PolymerResourcePackUtils.getInstance(), so you can't copy settings from other sources to it!");
        }
        ResourcePackExtras extras = new ResourcePackExtras(creator);
        extras.bridgedModels.putAll(source.bridgedModels);
        return extras;
    }

    public static class_2960 bridgeModelNoItem(class_2960 model) {
        if (model.method_12832().startsWith("item/")) {
            return model.method_45136(model.method_12832().substring("item/".length()));
        }
        return ResourcePackExtras.bridgeModel(model);
    }

    public static class_2960 bridgeModel(class_2960 model) {
        return model.method_45138("-/");
    }

    public boolean addBridgedModelsFolder(class_2960 modelFolderId) {
        return this.addBridgedModelsFolder(modelFolderId, (class_2960 identifier, ResourcePackBuilder resourcePackBuilder) -> new ItemAsset(new BasicItemModel((class_2960)identifier), ItemAsset.Properties.DEFAULT));
    }

    public boolean addBridgedModelsFolderWithColor(class_2960 modelFolderId) {
        return this.addBridgedModelsFolder(modelFolderId, (class_2960 identifier, ResourcePackBuilder resourcePackBuilder) -> new ItemAsset(new BasicItemModel((class_2960)identifier, List.of(new CustomModelDataTintSource(0, 0xFFFFFF), new CustomModelDataTintSource(1, 0xFFFFFF), new CustomModelDataTintSource(2, 0xFFFFFF), new CustomModelDataTintSource(3, 0xFFFFFF))), ItemAsset.Properties.DEFAULT));
    }

    public boolean addBridgedModelsFolder(class_2960 modelFolderId, BiFunction<class_2960, ResourcePackBuilder, @Nullable ItemAsset> bridgeBuilder) {
        this.bridgedModels.put(modelFolderId.method_12832().endsWith("/") ? modelFolderId.method_45134(x -> x.substring(0, x.length() - 1)) : modelFolderId, bridgeBuilder);
        return true;
    }

    public boolean addBridgedModelsFolder(class_2960 ... modelFolderId) {
        boolean b = true;
        for (class_2960 model : modelFolderId) {
            b &= this.addBridgedModelsFolder(model);
        }
        return b;
    }

    public boolean addBridgedModelsFolder(Collection<class_2960> modelFolderId) {
        boolean b = true;
        for (class_2960 model : modelFolderId) {
            b &= this.addBridgedModelsFolder(model);
        }
        return b;
    }

    public boolean addBridgedModelsFolder(Collection<class_2960> modelFolderId, BiFunction<class_2960, ResourcePackBuilder, @Nullable ItemAsset> bridgeBuilder) {
        boolean b = true;
        for (class_2960 model : modelFolderId) {
            b &= this.addBridgedModelsFolder(model, bridgeBuilder);
        }
        return b;
    }

    private void setup(ResourcePackBuilder builder) {
        if (!this.bridgedModels.isEmpty()) {
            builder.addPreFinishTask(b -> b.forEachResource((path, out) -> {
                if (!path.startsWith("assets/")) {
                    return;
                }
                String originalPath = path;
                path = path.substring("assets/".length());
                for (Map.Entry<class_2960, BiFunction<class_2960, ResourcePackBuilder, ItemAsset>> x : this.bridgedModels.entrySet()) {
                    class_2960 key = x.getKey();
                    String y = key.method_12836() + "/models/" + key.method_12832() + "/";
                    if (!path.startsWith(y)) continue;
                    if (!path.endsWith(".json")) {
                        return;
                    }
                    try {
                        path = path.substring(key.method_12836().length() + "/models/".length(), path.length() - ".json".length());
                        String assetPath = AssetPaths.itemAsset((class_2960)key.method_45136("-/" + path));
                        if (b.getData(assetPath) != null) {
                            return;
                        }
                        ItemAsset asset = x.getValue().apply(key.method_45136(path), (ResourcePackBuilder)b);
                        if (asset != null) {
                            b.addData(assetPath, asset.toJson().getBytes(StandardCharsets.UTF_8));
                        }
                        return;
                    }
                    catch (Throwable e) {
                        CommonImpl.LOGGER.warn("Invalid resource pack file! {}", (Object)originalPath, (Object)e);
                    }
                }
            }));
        }
    }
}

