/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.extras.api.format.font;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.polymer.resourcepack.api.WritableAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.font.FontProvider;
import eu.pb4.polymer.resourcepack.extras.api.format.font.FontProviderEntry;
import eu.pb4.polymer.resourcepack.extras.api.format.font.FontProviderFilter;
import java.util.ArrayList;
import java.util.List;

public record FontAsset(List<FontProviderEntry> providers) implements WritableAsset.Json
{
    public static final Codec<FontAsset> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FontProviderEntry.CODEC.listOf().fieldOf("providers").forGetter(FontAsset::providers)).apply((Applicative)instance, FontAsset::new));

    public String toJson() {
        return ((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow()).toString();
    }

    public static FontAsset fromJson(String json) {
        return (FontAsset)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)json)).getOrThrow()).getFirst();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<FontProviderEntry> providers = new ArrayList<FontProviderEntry>();

        private Builder() {
        }

        public Builder add(FontProvider provider) {
            this.providers.add(new FontProviderEntry(provider));
            return this;
        }

        public Builder add(FontProvider provider, FontProviderFilter filter) {
            this.providers.add(new FontProviderEntry(provider, filter));
            return this;
        }

        public Builder add(FontProvider.Builder provider) {
            this.providers.add(new FontProviderEntry(provider.build()));
            return this;
        }

        public Builder add(FontProvider.Builder provider, FontProviderFilter filter) {
            this.providers.add(new FontProviderEntry(provider.build(), filter));
            return this;
        }

        public Builder add(FontProviderEntry entry) {
            this.providers.add(entry);
            return this;
        }

        public FontAsset build() {
            return new FontAsset(this.providers);
        }
    }
}

