/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.extras.api.format.sound;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.polymer.common.impl.SortedMapCodec;
import eu.pb4.polymer.resourcepack.api.WritableAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.sound.SoundEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public record SoundsAsset(Map<String, SoundEntry> sounds) implements WritableAsset.Json
{
    public static final Codec<SoundsAsset> CODEC = SortedMapCodec.of((Codec)Codec.STRING, SoundEntry.CODEC).xmap(SoundsAsset::new, SoundsAsset::sounds);

    public String toJson() {
        return ((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow()).toString();
    }

    public static SoundsAsset fromJson(String json) {
        return (SoundsAsset)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)json)).getOrThrow()).getFirst();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, SoundEntry> sounds = new HashMap<String, SoundEntry>();

        private Builder() {
        }

        public Builder add(String path, SoundEntry entry) {
            this.sounds.put(path, entry);
            return this;
        }

        public Builder add(String path, SoundEntry.Builder entry) {
            this.sounds.put(path, entry.build());
            return this;
        }

        public Builder add(String path, Consumer<SoundEntry.Builder> builderConsumer) {
            SoundEntry.Builder b = SoundEntry.builder();
            builderConsumer.accept(b);
            this.sounds.put(path, b.build());
            return this;
        }

        public SoundsAsset build() {
            return new SoundsAsset(new HashMap<String, SoundEntry>(this.sounds));
        }
    }
}

