/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.extras.api.format.blockstate;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.polymer.resourcepack.extras.api.format.blockstate.StateModelVariant;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_3542;
import net.minecraft.class_5699;

public record StateMultiPartDefinition(Optional<Condition> when, List<StateModelVariant> apply) {
    public static final Codec<StateMultiPartDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Condition.CODEC.optionalFieldOf("when").forGetter(StateMultiPartDefinition::when), (App)StateModelVariant.CODEC.fieldOf("apply").forGetter(StateMultiPartDefinition::apply)).apply((Applicative)instance, StateMultiPartDefinition::new));

    public static sealed interface Condition
    permits CombinedCondition, KeyValueCondition {
        public static final Codec<Condition> CODEC = Codec.recursive((String)"condition", self -> {
            Codec combinerCodec = Codec.simpleMap(CombinedCondition.Operation.CODEC, (Codec)self.listOf(), (Keyable)class_3542.method_28142((class_3542[])CombinedCondition.Operation.values())).codec().comapFlatMap(map -> {
                if (map.size() != 1) {
                    return DataResult.error(() -> "Invalid map size for combiner condition, expected exactly one element");
                }
                Map.Entry entry = map.entrySet().iterator().next();
                return DataResult.success((Object)new CombinedCondition((CombinedCondition.Operation)((Object)((Object)((Object)entry.getKey()))), (List)entry.getValue()));
            }, condition -> Map.of(condition.operation(), condition.terms()));
            return Codec.either((Codec)combinerCodec, KeyValueCondition.CODEC).flatComapMap(either -> (Condition)either.map(l -> l, r -> r), condition -> {
                Condition condition2 = condition;
                Objects.requireNonNull(condition2);
                Condition selector0$temp = condition2;
                int index$1 = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CombinedCondition.class, KeyValueCondition.class}, (Object)selector0$temp, index$1)) {
                    case 0 -> {
                        CombinedCondition combiner = (CombinedCondition)selector0$temp;
                        yield DataResult.success((Object)Either.left((Object)combiner));
                    }
                    case 1 -> {
                        KeyValueCondition keyValue = (KeyValueCondition)selector0$temp;
                        yield DataResult.success((Object)Either.right((Object)keyValue));
                    }
                    default -> DataResult.error(() -> "Unrecognized condition");
                };
            });
        });
    }

    public record KeyValueCondition(Map<String, Terms> tests) implements Condition
    {
        public static final Codec<KeyValueCondition> CODEC = class_5699.method_63572((Codec)Codec.unboundedMap((Codec)Codec.STRING, Terms.CODEC)).xmap(KeyValueCondition::new, KeyValueCondition::tests);

        public record Terms(List<Term> entries) {
            private static final char SEPARATOR = '|';
            private static final Joiner JOINER = Joiner.on((char)'|');
            private static final Splitter SPLITTER = Splitter.on((char)'|');
            private static final Codec<String> LEGACY_REPRESENTATION_CODEC = Codec.either((Codec)Codec.INT, (Codec)Codec.BOOL).flatComapMap(either -> (String)either.map(String::valueOf, String::valueOf), o -> DataResult.error(() -> "This codec can't be used for encoding"));
            public static final Codec<Terms> CODEC = Codec.withAlternative((Codec)Codec.STRING, LEGACY_REPRESENTATION_CODEC).comapFlatMap(Terms::parse, Terms::toString);

            public Terms {
                if (entries.isEmpty()) {
                    throw new IllegalArgumentException("Empty value for property");
                }
            }

            public static DataResult<Terms> parse(String value) {
                List<Term> terms = SPLITTER.splitToStream((CharSequence)value).map(Term::parse).toList();
                if (terms.isEmpty()) {
                    return DataResult.error(() -> "Empty value for property");
                }
                for (Term entry : terms) {
                    if (!entry.value.isEmpty()) continue;
                    return DataResult.error(() -> "Empty term in value '" + value + "'");
                }
                return DataResult.success((Object)new Terms(terms));
            }

            @Override
            public String toString() {
                return JOINER.join(this.entries);
            }
        }

        public record Term(String value, boolean negated) {
            private static final String NEGATE = "!";

            public Term {
                if (value.isEmpty()) {
                    throw new IllegalArgumentException("Empty term");
                }
            }

            public static Term parse(String value) {
                return value.startsWith(NEGATE) ? new Term(value.substring(1), true) : new Term(value, false);
            }

            @Override
            public String toString() {
                return this.negated ? NEGATE + this.value : this.value;
            }
        }
    }

    public record CombinedCondition(Operation operation, List<Condition> terms) implements Condition
    {

        public static enum Operation implements class_3542
        {
            AND("AND"),
            OR("OR");

            public static final Codec<Operation> CODEC;
            private final String name;

            private Operation(String name) {
                this.name = name;
            }

            public String method_15434() {
                return this.name;
            }

            static {
                CODEC = class_3542.method_28140(Operation::values);
            }
        }
    }
}

