package eu.pb4.polymer.resourcepack.extras.api.format.item.model;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import eu.pb4.polymer.common.impl.LazyIdMapper;
import org.jetbrains.annotations.Nullable;

import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_5699;

public interface ItemModel {
    Codec<ItemModel> CODEC = Codec.lazyInitialized(() -> ItemModel.TYPES.method_65323(class_2960.field_25139).dispatch(ItemModel::codec, Function.identity()));
    class_5699.class_10388<class_2960, MapCodec<? extends ItemModel>> TYPES = new LazyIdMapper<>(m -> {
        m.method_65325(class_2960.method_60656("empty"), EmptyItemModel.CODEC);
        m.method_65325(class_2960.method_60656("model"), BasicItemModel.CODEC);
        m.method_65325(class_2960.method_60656("special"), SpecialItemModel.CODEC);
        m.method_65325(class_2960.method_60656("composite"), CompositeItemModel.CODEC);
        m.method_65325(class_2960.method_60656("bundle/selected_item"), BundleSelectedItemModel.CODEC);
        m.method_65325(class_2960.method_60656("range_dispatch"), RangeDispatchItemModel.CODEC);
        m.method_65325(class_2960.method_60656("select"), SelectItemModel.CODEC);
        m.method_65325(class_2960.method_60656("condition"), ConditionItemModel.CODEC);
    });

    MapCodec<? extends ItemModel> codec();
    default ItemModel replaceChildren(Replacer replacer) {
        return this;
    }

    interface Replacer {
        Replacer NO_OP = (a, b) -> b;
        @Nullable
        ItemModel modify(ItemModel parent, ItemModel model);

        @Nullable
        default ItemModel modifyDeep(ItemModel parent, ItemModel model) {
            var newModel = this.modify(parent, model);
            if (newModel == model) {
                return model.replaceChildren(this);
            }
            return newModel;
        }
    }
}
