/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.api;

import eu.pb4.polymer.resourcepack.impl.generation.resource.ByteArrayPackResource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface PackResource {
    public byte[] readAllBytes();

    public InputStream getStream();

    public static PackResource of(byte[] t) {
        return new ByteArrayPackResource(t);
    }

    public static PackResource of(InputStream stream) throws IOException {
        return new ByteArrayPackResource(stream.readAllBytes());
    }

    public static PackResource of(Path path) throws IOException {
        return new ByteArrayPackResource(Files.readAllBytes(path));
    }
}

