package eu.pb4.polymer.resourcepack.impl;

import com.google.gson.annotations.SerializedName;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CompatStatus;
import net.fabricmc.loader.api.FabricLoader;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class PolymerResourcePackImpl {
    public static final boolean FORCE_REQUIRE;
    public static final UUID MAIN_UUID;
    public static final Path DEFAULT_PATH;
    public static final String FILE_NAME;
    public static final boolean IGNORE_PACK_VERSION;
    public static final boolean LOG_ERRORS;


    static {
        var config = loadConfig();

        DEFAULT_PATH = FabricLoader.getInstance().getGameDir().resolve(config.resourcePackPath);
        FILE_NAME = config.resourcePackPath;

        MAIN_UUID = config.mainUuid;
        IGNORE_PACK_VERSION = config.ignorePackVersion;

        FORCE_REQUIRE = config.markResourcePackAsRequiredByDefault || CompatStatus.POLYMC;
        LOG_ERRORS = config.logErrors || FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static Config loadConfig() {
        return CommonImpl.loadAndRegisterConfig("resource-pack", Config.class);
    }


    public static class Config {
        public String _c0 = "UUID of default/main resource pack.";
        @SerializedName("main_uuid")
        public UUID mainUuid = UUID.randomUUID();
        public String _c1 = "Marks resource pack as required, only effects clients and mods using api to check it";
        public boolean markResourcePackAsRequiredByDefault = false;
        public String _c5 = "Included resource packs from mods!";
        @SerializedName("include_mod_assets")
        public List<String> includeModAssets = new ArrayList<>();
        public String _c6 = "Included resource packs from zips!";
        @SerializedName("include_zips")
        public List<String> includeZips = List.of("world/resources.zip");
        public String _c7 = "Path used for creation of default resourcepack!";
        @SerializedName("resource_pack_location")
        public String resourcePackPath = "polymer/resource_pack.zip";
        public String _c8 = "Prevents selected paths from being added to resource pack, if they start with provided text.";
        @SerializedName("prevent_path_with")
        public List<String> preventedPaths = List.of();
        public String _c9 = "Removes the incompatibility warning on the default pack, by marking it as compatible with everything.";
        @SerializedName("ignore_pack_version")
        public boolean ignorePackVersion = false;
        public String _c10 = "Toggles logging of non-critical errors when generating the pack.";
        @SerializedName("log_errors")
        public boolean logErrors = true;
    }
}
