/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.api;

import eu.pb4.polymer.common.api.events.SimpleEvent;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.impl.generation.DefaultRPBuilder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_3264;
import net.minecraft.class_3272;
import net.minecraft.class_6497;
import org.jetbrains.annotations.Nullable;

public final class ResourcePackCreator {
    public final SimpleEvent<Consumer<ResourcePackBuilder>> creationEvent = new SimpleEvent();
    public final SimpleEvent<Runnable> finishedEvent = new SimpleEvent();
    public final SimpleEvent<Consumer<ResourcePackBuilder>> afterInitialCreationEvent = new SimpleEvent();
    private final Set<String> modIds = new HashSet<String>();
    private final Set<String> modIdsNoCopy = new HashSet<String>();
    private final Set<Path> sourcePaths = new HashSet<Path>();
    private class_2561 packDescription = null;
    private byte[] packIcon = null;

    ResourcePackCreator() {
    }

    public static ResourcePackCreator forDefault() {
        return PolymerResourcePackUtils.getInstance();
    }

    public static ResourcePackCreator create() {
        return new ResourcePackCreator();
    }

    public static ResourcePackCreator createCopy(ResourcePackCreator source, boolean copyEvents) {
        ResourcePackCreator creator = new ResourcePackCreator();
        if (copyEvents) {
            source.creationEvent.invokers().forEach(arg_0 -> creator.creationEvent.register(arg_0));
            source.afterInitialCreationEvent.invokers().forEach(arg_0 -> creator.afterInitialCreationEvent.register(arg_0));
            source.finishedEvent.invokers().forEach(arg_0 -> creator.finishedEvent.register(arg_0));
        }
        creator.modIds.addAll(source.modIds);
        creator.modIdsNoCopy.addAll(source.modIdsNoCopy);
        creator.packDescription = source.packDescription;
        creator.packIcon = source.packIcon;
        creator.sourcePaths.addAll(source.sourcePaths);
        return creator;
    }

    public boolean addAssetSource(String modId) {
        if (CommonImpl.isModLoaded((String)modId)) {
            this.modIds.add(modId);
            return true;
        }
        return false;
    }

    public boolean addAssetSourceWithoutCopy(String modId) {
        if (CommonImpl.isModLoaded((String)modId)) {
            this.modIdsNoCopy.add(modId);
            return true;
        }
        return false;
    }

    public boolean addAssetSource(Path sourcePath) {
        return this.sourcePaths.add(sourcePath);
    }

    @Nullable
    public class_2561 getPackDescription() {
        return this.packDescription;
    }

    public void setPackDescription(String description) {
        this.packDescription = class_2561.method_43470((String)description);
    }

    public void setPackDescription(class_2561 description) {
        this.packDescription = description;
    }

    @Nullable
    public byte[] getPackIcon() {
        return this.packIcon;
    }

    public void setPackIcon(byte[] packIcon) {
        this.packIcon = packIcon;
    }

    public boolean isEmpty() {
        return this.modIds.isEmpty() && this.creationEvent.isEmpty();
    }

    public boolean build(Path output) throws ExecutionException, InterruptedException {
        return this.build(output, s -> {});
    }

    public boolean build(Path output, Consumer<String> status) throws ExecutionException, InterruptedException {
        boolean successful = true;
        try {
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
        }
        catch (Throwable e) {
            CommonImpl.LOGGER.error("Couldn't create " + String.valueOf(output.getParent()) + " directory!", e);
        }
        try {
            if (output.toFile().exists()) {
                Files.deleteIfExists(output);
            }
        }
        catch (Exception e) {
            CommonImpl.LOGGER.error("Couldn't remove " + String.valueOf(output) + " file!", (Throwable)e);
        }
        DefaultRPBuilder builder = new DefaultRPBuilder(ResourcePackBuilder.OutputGenerator.zipGenerator(output), status);
        status.accept("action:created_builder");
        if (this.packDescription != null) {
            builder.getPackMcMetaBuilder().metadata(new class_3272(this.packDescription, new class_6497((Comparable)class_155.method_16673().method_70592(class_3264.field_14188))));
        }
        if (this.packIcon != null) {
            builder.addData("pack.png", this.packIcon);
        }
        status.accept("action:creation_event_start");
        this.creationEvent.invoke(x -> x.accept(builder));
        status.accept("action:creation_event_finish");
        for (Path path : this.sourcePaths) {
            successful = builder.copyFromPath(path) && successful;
        }
        for (String modId : this.modIdsNoCopy) {
            successful = builder.addAssetsSource(modId) && successful;
        }
        for (String modId : this.modIds) {
            successful = builder.copyAssets(modId) && successful;
        }
        status.accept("action:late_creation_event_start");
        this.afterInitialCreationEvent.invoke(x -> x.accept(builder));
        status.accept("action:late_creation_event_finish");
        status.accept("action:build");
        successful = builder.buildResourcePack().get() != false && successful;
        status.accept("action:done");
        this.finishedEvent.invoke(Runnable::run);
        return successful;
    }
}

