/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import eu.pb4.polymer.resourcepack.api.WritableAsset;
import eu.pb4.polymer.resourcepack.impl.generation.resource.ByteArrayPackResource;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface PackResource {
    public byte[] readAllBytes();

    public InputStream getStream();

    public static PackResource of(byte[] t) {
        return new ByteArrayPackResource(t);
    }

    @Nullable
    default public String asString() {
        return new String(this.readAllBytes(), StandardCharsets.UTF_8);
    }

    @Nullable
    default public JsonElement asJson() {
        try {
            return JsonParser.parseString((String)this.asString());
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Nullable
    default public BufferedImage asImage() {
        try {
            return ImageIO.read(this.getStream());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static PackResource fromString(String string) {
        return new ByteArrayPackResource(string.getBytes(StandardCharsets.UTF_8));
    }

    public static PackResource fromAsset(WritableAsset asset) {
        return new ByteArrayPackResource(asset.toBytes());
    }

    public static PackResource fromJson(JsonElement jsonElement) {
        return PackResource.fromString(jsonElement.toString());
    }

    public static PackResource fromImage(BufferedImage image) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayPackResource(b.toByteArray());
    }

    public static PackResource of(InputStream stream) throws IOException {
        return new ByteArrayPackResource(stream.readAllBytes());
    }

    public static PackResource of(Path path) throws IOException {
        return new ByteArrayPackResource(Files.readAllBytes(path));
    }
}

