/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.api;

import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.common.api.events.SimpleEvent;
import eu.pb4.polymer.common.impl.CommonClientConnectionExt;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.common.impl.CommonNetworkHandlerExt;
import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.api.ResourcePackCreator;
import eu.pb4.polymer.resourcepack.api.metadata.PackMcMeta;
import eu.pb4.polymer.resourcepack.impl.PolymerResourcePackImpl;
import eu.pb4.polymer.resourcepack.impl.compat.polymc.PolyMcHelpers;
import eu.pb4.polymer.resourcepack.impl.generation.DefaultRPBuilder;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11555;
import net.minecraft.class_155;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3272;
import net.minecraft.class_6497;
import net.minecraft.class_8609;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public final class PolymerResourcePackUtils {
    private static final ResourcePackCreator INSTANCE = new ResourcePackCreator();
    public static final SimpleEvent<Consumer<ResourcePackBuilder>> RESOURCE_PACK_CREATION_EVENT = PolymerResourcePackUtils.INSTANCE.creationEvent;
    public static final SimpleEvent<Consumer<ResourcePackBuilder>> RESOURCE_PACK_AFTER_INITIAL_CREATION_EVENT = PolymerResourcePackUtils.INSTANCE.afterInitialCreationEvent;
    public static final SimpleEvent<Runnable> RESOURCE_PACK_FINISHED_EVENT = PolymerResourcePackUtils.INSTANCE.finishedEvent;
    private static boolean REQUIRED = PolymerResourcePackImpl.FORCE_REQUIRE;
    private static boolean DEFAULT_CHECK = true;

    private PolymerResourcePackUtils() {
    }

    public static boolean addModAssets(String modId) {
        return INSTANCE.addAssetSource(modId);
    }

    public static boolean addModAssetsWithoutCopy(String modId) {
        return INSTANCE.addAssetSourceWithoutCopy(modId);
    }

    public static boolean hasResources() {
        return !INSTANCE.isEmpty();
    }

    public static void markAsRequired() {
        REQUIRED = true;
    }

    public static boolean isRequired() {
        return REQUIRED;
    }

    public static boolean hasPack(@Nullable class_3222 player, UUID uuid) {
        return PolymerCommonUtils.hasResourcePack((class_3222)player, (UUID)uuid);
    }

    public static boolean hasPack(PacketContext context, UUID uuid) {
        return PolymerCommonUtils.hasResourcePack((PacketContext)context, (UUID)uuid);
    }

    public static boolean hasPack(class_8609 handler, UUID uuid) {
        return PolymerCommonUtils.hasResourcePack((class_8609)handler, (UUID)uuid);
    }

    public static boolean hasMainPack(@Nullable class_3222 player) {
        return PolymerResourcePackUtils.hasPack(player, PolymerResourcePackUtils.getMainUuid());
    }

    public static boolean hasMainPack(PacketContext context) {
        return PolymerResourcePackUtils.hasPack(context, PolymerResourcePackUtils.getMainUuid());
    }

    public static boolean hasMainPack(class_8609 handler) {
        return PolymerResourcePackUtils.hasPack(handler, PolymerResourcePackUtils.getMainUuid());
    }

    public static Path getMainPath() {
        return PolymerResourcePackImpl.DEFAULT_PATH;
    }

    public static UUID getMainUuid() {
        return PolymerResourcePackImpl.MAIN_UUID;
    }

    public static void setPlayerStatus(class_3222 player, UUID uuid, boolean status) {
        if (player.field_13987 != null) {
            ((CommonClientConnectionExt)player.field_13987).polymerCommon$setResourcePack(uuid, status);
        }
    }

    public static void disableDefaultCheck() {
        DEFAULT_CHECK = false;
        CommonImplUtils.disableResourcePackCheck = true;
    }

    public static boolean shouldCheckByDefault() {
        return DEFAULT_CHECK;
    }

    public static void ignoreNextDefaultCheck(class_3222 player) {
        ((CommonNetworkHandlerExt)player.field_13987).polymerCommon$setIgnoreNextResourcePack();
    }

    public static ResourcePackBuilder createBuilder(Path output) {
        return new DefaultRPBuilder(ResourcePackBuilder.OutputGenerator.zipGenerator(output), s -> {});
    }

    public static ResourcePackBuilder createBuilder(ResourcePackBuilder.OutputGenerator generator) {
        return new DefaultRPBuilder(generator, s -> {});
    }

    public static boolean buildMain() {
        return PolymerResourcePackUtils.buildMain(PolymerResourcePackUtils.getMainPath());
    }

    public static boolean buildMain(Path output) {
        return PolymerResourcePackUtils.buildMain(output, s -> {});
    }

    public static boolean buildMain(Path output, Consumer<String> status) {
        try {
            return INSTANCE.build(output, status);
        }
        catch (Exception e) {
            CommonImpl.LOGGER.error("Couldn't create resource pack!");
            e.printStackTrace();
            return false;
        }
    }

    public static ResourcePackCreator getInstance() {
        return INSTANCE;
    }

    static {
        PolymerResourcePackUtils.INSTANCE.creationEvent.register(builder -> {
            Path path2;
            PolymerResourcePackImpl.Config config = PolymerResourcePackImpl.loadConfig();
            if (!config.preventedPaths.isEmpty()) {
                builder.addResourceConverter((path, data) -> {
                    for (String test : config.preventedPaths) {
                        if (!path.startsWith(test)) continue;
                        return null;
                    }
                    return data;
                });
            }
            if (Files.isDirectory(path2 = CommonImpl.getGameDir().resolve("polymer/source_assets"), new LinkOption[0])) {
                builder.copyFromPath(path2);
                try {
                    Path metafile = path2.resolve("pack.mcmeta");
                    if (Files.exists(metafile, new LinkOption[0])) {
                        PackMcMeta meta = PackMcMeta.fromString(Files.readString(metafile));
                        builder.getPackMcMetaBuilder().metadata(meta.pack());
                    } else if (PolymerResourcePackImpl.IGNORE_PACK_VERSION) {
                        class_3272 og = builder.getPackMcMetaBuilder().metadata();
                        builder.getPackMcMetaBuilder().metadata(new class_3272(og.comp_1580(), new class_6497((Comparable)class_155.method_16673().method_70592(class_3264.field_14188), (Comparable)new class_11555(Integer.MAX_VALUE, Integer.MAX_VALUE))));
                    }
                }
                catch (Throwable metafile) {
                    // empty catch block
                }
            }
            try {
                for (String field : config.includeModAssets) {
                    builder.copyAssets(field);
                }
                Path gamePath = FabricLoader.getInstance().getGameDir();
                Consumer<Path> zipReader = zipPath -> {
                    if (Files.exists(zipPath, new LinkOption[0])) {
                        try (FileSystem fs = FileSystems.newFileSystem(zipPath);){
                            for (Path root : fs.getRootDirectories()) {
                                builder.copyResourcePackFromPath(root, zipPath.getFileName().toString());
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                };
                for (String field : config.includeZips) {
                    String[] parts = field.split("/");
                    if (parts.length == 0) continue;
                    if (parts[parts.length - 1].contains("*")) {
                        Path folderPath = gamePath.resolve(String.join((CharSequence)"/", Arrays.copyOfRange(parts, 0, parts.length - 1)));
                        if (!Files.isDirectory(folderPath, new LinkOption[0])) continue;
                        DirectoryStream<Path> stream = Files.newDirectoryStream(folderPath, parts[parts.length - 1]);
                        try {
                            stream.forEach(zipReader);
                            continue;
                        }
                        finally {
                            if (stream != null) {
                                stream.close();
                            }
                            continue;
                        }
                    }
                    zipReader.accept(gamePath.resolve(field));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (CompatStatus.POLYMC) {
                try {
                    Files.createDirectories(path2, new FileAttribute[0]);
                    PolyMcHelpers.importPolyMcResources(builder);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        PolymerResourcePackUtils.INSTANCE.afterInitialCreationEvent.register(builder -> {
            Path path = CommonImpl.getGameDir().resolve("polymer/override_assets");
            if (Files.isDirectory(path, new LinkOption[0])) {
                builder.copyFromPath(path);
                try {
                    Path metafile = path.resolve("pack.mcmeta");
                    if (Files.exists(metafile, new LinkOption[0])) {
                        PackMcMeta meta = PackMcMeta.fromString(Files.readString(metafile));
                        builder.getPackMcMetaBuilder().metadata(meta.pack());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }
}

