/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.api;

import eu.pb4.polymer.resourcepack.api.PackResource;
import eu.pb4.polymer.resourcepack.api.WritableAsset;
import eu.pb4.polymer.resourcepack.api.metadata.PackMcMeta;
import eu.pb4.polymer.resourcepack.impl.generation.DefaultRPBuilder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.class_8617;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface ResourcePackBuilder {
    default public boolean addData(String path, byte[] data) {
        return this.addData(path, PackResource.of(data));
    }

    public boolean addData(String var1, PackResource var2);

    default public boolean addData(String path, WritableAsset data) {
        return this.addData(path, data.toBytes());
    }

    default public boolean addStringData(String path, String data) {
        return this.addData(path, data.getBytes(StandardCharsets.UTF_8));
    }

    public boolean copyAssets(String var1);

    public boolean copyFromPath(Path var1, String var2, boolean var3);

    default public boolean copyFromPath(Path path, String targetPrefix) {
        return this.copyFromPath(path, targetPrefix, true);
    }

    default public boolean copyFromPath(Path path) {
        return this.copyFromPath(path, "", true);
    }

    default public boolean copyFromPath(Path path, boolean override) {
        return this.copyFromPath(path, "", override);
    }

    default public boolean copyResourcePackFromPath(Path root) {
        return this.copyResourcePackFromPath(root, "__undefined__");
    }

    default public boolean copyResourcePackFromPath(Path root, String sourceName) {
        try {
            Object str;
            Path packmcmeta;
            Path assets = root.resolve("assets");
            if (Files.exists(assets, new LinkOption[0])) {
                this.copyFromPath(assets, "assets/");
            }
            if (Files.exists(packmcmeta = root.resolve("pack.mcmeta"), new LinkOption[0])) {
                try {
                    str = Files.readString(packmcmeta);
                    this.addData("pack.mcmeta", ((String)str).getBytes(StandardCharsets.UTF_8));
                    PackMcMeta pack = PackMcMeta.fromString((String)str);
                    if (pack.overlays().isPresent()) {
                        for (class_8617.class_8618 ov : pack.overlays().get().comp_1577()) {
                            Path assets2 = root.resolve(ov.comp_1579());
                            if (!Files.exists(assets2, new LinkOption[0])) continue;
                            this.copyFromPath(assets2, ov.comp_1579() + "/");
                        }
                    }
                }
                catch (Throwable err) {
                    this.logError("Failed to parse pack.mcmeta!", err);
                }
            }
            str = Files.list(root);
            try {
                str.forEach(file -> {
                    try {
                        String name = file.getFileName().toString();
                        if (name.toLowerCase(Locale.ROOT).contains("license") || name.toLowerCase(Locale.ROOT).contains("licence")) {
                            this.addData("licenses/" + sourceName.replace("/", "_").replace("\\", "_") + "/" + name, PackResource.of(file));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
            }
            finally {
                if (str != null) {
                    str.close();
                }
            }
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public byte @Nullable [] getData(String var1);

    @Nullable
    public PackResource getResource(String var1);

    public byte @Nullable [] getDataOrSource(String var1);

    @Nullable
    default public String getStringData(String path) {
        byte[] data = this.getData(path);
        return data != null ? new String(data, StandardCharsets.UTF_8) : null;
    }

    @Nullable
    default public String getStringDataOrSource(String path) {
        byte[] data = this.getDataOrSource(path);
        return data != null ? new String(data, StandardCharsets.UTF_8) : null;
    }

    @Deprecated(forRemoval=true)
    default public void forEachFile(BiConsumer<String, byte[]> consumer) {
        this.forEachResource((a, b) -> consumer.accept((String)a, b.readAllBytes()));
    }

    public void forEachResource(BiConsumer<String, PackResource> var1);

    public boolean addAssetsSource(String var1);

    public void addResourceConverter(ResourceConverter var1);

    @Deprecated(forRemoval=true)
    default public void addWriteConverter(BiFunction<String, byte[], byte @Nullable []> converter) {
        this.addResourceConverter((path, data) -> {
            byte[] t = (byte[])converter.apply(path, data.readAllBytes());
            return t != null ? PackResource.of(t) : null;
        });
    }

    public void addPreFinishTask(Consumer<ResourcePackBuilder> var1);

    default public PackMcMeta.Builder getPackMcMetaBuilder() {
        return new PackMcMeta.Builder();
    }

    default public boolean addModToCredits(String modId) {
        return false;
    }

    default public void logError(String s, @Nullable Throwable er) {
    }

    public static interface ResourceConverter {
        public static final ResourceConverter NO_OP = (a, b) -> b;

        @Nullable
        public PackResource convert(String var1, PackResource var2);
    }

    public static interface OutputGenerator {
        public boolean generateFile(List<Map.Entry<String, PackResource>> var1, ResourceConverter var2, Consumer<String> var3);

        public static OutputGenerator zipGenerator(Path out) {
            return (a, b, c) -> DefaultRPBuilder.writeSingleZip(out, a, b, c);
        }
    }
}

