package eu.pb4.polymer.resourcepack.api;

import net.minecraft.class_2960;

public final class AssetPaths {
    public static String PACK_METADATA = "pack.mcmeta";
    public static String PACK_ICON = "pack.png";

    private AssetPaths() {}

    public static String texture(String namespace, String path) {
        return "assets/" + namespace + "/textures/" + path;
    }

    public static String model(String namespace, String path) {
        return "assets/" + namespace + "/models/" + path;
    }

    public static String model(class_2960 id) {
        return model(id.method_12836(), id.method_12832());
    }

    public static String texture(class_2960 id) {
        return texture(id.method_12836(), id.method_12832());
    }

    public static String blockModel(class_2960 id) {
        return model(id.method_12836(), "block/" + id.method_12832() + ".json");
    }

    public static String blockTexture(class_2960 id) {
        return texture(id.method_12836(), "block/" + id.method_12832() + ".png");
    }

    public static String blockTextureMetadata(class_2960 id) {
        return texture(id.method_12836(), "block/" + id.method_12832() + ".png.mcmeta");
    }

    public static String itemModel(class_2960 id) {
        return model(id.method_12836(), "item/" + id.method_12832() + ".json");
    }

    public static String itemTexture(class_2960 id) {
        return texture(id.method_12836(), "item/" + id.method_12832() + ".png");
    }

    public static String itemTextureMetadata(class_2960 id) {
        return texture(id.method_12836(), "item/" + id.method_12832() + ".png.mcmeta");
    }

    public static String itemAsset(class_2960 identifier) {
        return "assets/" + identifier.method_12836() + "/items/" + identifier.method_12832() + ".json";
    }

    public static String soundsAsset(String namespace) {
        return "assets/" + namespace + "/sounds.json";
    }


    //public static String armorTexture(Identifier id, int layer) {
    //    return texture(id.getNamespace(), "models/armor/" + id.getPath() + "_layer_" + layer + ".png");
    //}

    //public static String armorOverlayTexture(Identifier id, int layer) {
    //    return texture(id.getNamespace(), "models/armor/" + id.getPath() + "_layer_" + layer + "_overlay.png");
    //}
}
