package eu.pb4.polymer.resourcepack.api;

import eu.pb4.polymer.resourcepack.api.metadata.PackMcMeta;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.class_8617.class_8618;

@ApiStatus.NonExtendable
public interface ResourcePackBuilder {
    boolean addData(String path, byte[] data);

    boolean copyAssets(String modId);

    boolean copyFromPath(Path path, String targetPrefix, boolean override);

    default boolean copyFromPath(Path path, String targetPrefix) {
        return this.copyFromPath(path, targetPrefix, true);
    }

    default boolean copyFromPath(Path path) {
        return this.copyFromPath(path, "", true);
    }

    default boolean copyFromPath(Path path, boolean override) {
        return this.copyFromPath(path, "", override);
    }

    default boolean copyResourcePackFromPath(Path root) {
        return copyResourcePackFromPath(root, "__undefined__");
    }

    default boolean copyResourcePackFromPath(Path root, String field) {
        try {
            {
                var assets = root.resolve("assets");
                if (Files.exists(assets)) {
                    copyFromPath(assets, "assets/");
                }
            }

            var packmcmeta = root.resolve("pack.mcmeta");
            if (Files.exists(packmcmeta)) {
                try {
                    var str = Files.readString(packmcmeta);
                    this.addData("pack.mcmeta", str.getBytes(StandardCharsets.UTF_8));

                    var pack = PackMcMeta.fromString(str);
                    if (pack.overlays().isPresent()) {
                        for (var ov : pack.overlays().get().comp_1577()) {
                            var assets = root.resolve(ov.comp_1579());
                            if (Files.exists(assets)) {
                                copyFromPath(assets, ov.comp_1579() + "/");
                            }
                        }
                    }

                } catch (Throwable ignored) {}
            }

            try (var str = Files.list(root)) {
                str.forEach(file -> {
                    try {
                        var name = file.getFileName().toString();
                        if (name.toLowerCase(Locale.ROOT).contains("license")
                                || name.toLowerCase(Locale.ROOT).contains("licence")) {
                            this.addData("licenses/"
                                    + field.replace("/", "_").replace("\\", "_") + "/" + name, Files.readAllBytes(file));
                        }
                    } catch (Throwable ignored) {
                    }
                });
            }
            return true;
        } catch (Throwable ignored) {
            return false;
        }
    }

    boolean addCustomModelData(PolymerModelData itemModel);

    boolean addArmorModel(PolymerArmorModel model);

    @Nullable
    byte[] getData(String path);

    @Nullable
    byte[] getDataOrSource(String path);

    boolean addAssetsSource(String modId);

    void addWriteConverter(BiFunction<String, byte[], @Nullable byte[]> converter);

    default PackMcMeta.Builder getPackMcMetaBuilder() {
        return new PackMcMeta.Builder();
    }
}
