package eu.pb4.polymer.resourcepack.api.model;

import com.google.gson.JsonObject;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.class_2960;

public record ItemOverride(Object2FloatMap<class_2960> predicate, class_2960 model) {
    /**
     * All Items
     */
    public static class_2960 CUSTOM_MODEL_DATA = class_2960.method_60654("custom_model_data");
    public static class_2960 LEFT_HANDED = class_2960.method_60654("lefthanded");
    public static class_2960 COOLDOWN = class_2960.method_60654("cooldown");
    public static class_2960 DAMAGED = class_2960.method_60654("damaged");
    public static class_2960 DAMAGE = class_2960.method_60654("damage");

    /**
     * Bows and crossbows
     */
    public static class_2960 PULL = class_2960.method_60654("pull");
    public static class_2960 PULLING = class_2960.method_60654("pulling");
    /**
     * Crossbows
     */
    public static class_2960 CHARGED = class_2960.method_60654("charged");
    public static class_2960 FIREWORK = class_2960.method_60654("firework");
    /**
     * Bundle
     */
    public static class_2960 FILLED = class_2960.method_60654("filled");
    /**
     * Clock
     */
    public static class_2960 TIME = class_2960.method_60654("time");
    /**
     * Compass
     */
    public static class_2960 ANGLE = class_2960.method_60654("angle");
    /**
     * Elytra
     */
    public static class_2960 BROKEN = class_2960.method_60654("broken");
    /**
     * Fishing rod
     */
    public static class_2960 CAST = class_2960.method_60654("cast");
    /**
     * Shield
     */
    public static class_2960 BLOCKING = class_2960.method_60654("blocking");
    /**
     * Trident
     */
    public static class_2960 THROWING = class_2960.method_60654("throwing");
    /**
     * Light
     */
    public static class_2960 LEVEL = class_2960.method_60654("level");
    /**
     * Goat Horn
     */
    public static class_2960 TOOTING = class_2960.method_60654("tooting");

    public static ItemOverride of(class_2960 model) {
        return new ItemOverride(new Object2FloatOpenHashMap<>(), model);
    }

    public static ItemOverride of(class_2960 model, class_2960 key, float value) {
        return of(model).set(key, value);
    }

    public ItemOverride set(class_2960 key, float value) {
        this.predicate.put(key, value);
        return this;
    }

    public JsonObject toJson() {
        var object = new JsonObject();
        object.addProperty("model", CommonImplUtils.shortId(this.model));
        var pred = new JsonObject();
        var entries = new ArrayList<>(predicate.keySet());
        entries.sort(Comparator.comparing(x -> x));
        for (var key : entries) {
            pred.addProperty(CommonImplUtils.shortId(key), predicate.getFloat(key));
        }
        object.add("predicate", pred);
        return object;
    }
}
