package eu.pb4.polymer.resourcepack.impl.client.rendering;

import D;
import J;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.JsonOps;
import eu.pb4.polymer.resourcepack.impl.ArmorTextureMetadata;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.class_1011;
import net.minecraft.class_1049;
import net.minecraft.class_1061;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class PolymerArmorResourceTexture extends class_1049 implements class_1061 {
    public int width = -1;
    public int height = -1;
    public int index = 0;
    private ArmorTextureMetadata metadata = ArmorTextureMetadata.DEFAULT;
    private class_1011 baseTexture;
    private class_1011 altTexture;
    private boolean animation;
    private int nextIndex;
    private long startingTime;

    public PolymerArmorResourceTexture(class_2960 location) {
        super(location);
    }

    @Override
    public void method_4625(class_3300 manager) throws IOException {
        class_1049.class_4006 textureData = this.method_18153(manager);
        textureData.method_18158();

        var id = class_2960.method_60655(this.field_5224.method_12836(), this.field_5224.method_12832().substring(0, (this.field_5224.method_12832().length() - 3)) + "polymer.json");

        var res = manager.method_14486(id);
        if (res.isPresent()) {
            var val = ArmorTextureMetadata.CODEC.decode(JsonOps.INSTANCE, JsonParser.parseString(new String(res.get().method_14482().readAllBytes()))).result();

            if (val.isPresent()){
                this.metadata = val.get().getFirst();
            }

        }

        this.width = 64 * this.metadata.scale();
        this.height = 32 * this.metadata.scale();
        this.animation = this.metadata.frames() > 1;

        class_1011 nativeImage = textureData.method_18157();

        this.baseTexture = nativeImage;
        if (this.metadata.interpolate()) {
            this.altTexture = new class_1011(this.width, this.height, false);
        }

        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this.upload(nativeImage));
        } else {
            this.upload(nativeImage);
        }
    }

    private void upload(class_1011 nativeImage) {
        TextureUtil.prepareImage(this.method_4624(), 0, this.width, this.height);
        nativeImage.method_22619(0, 0, 0, 0, 0, this.width, this.height, false, false, false, false);
    }

    private void update(class_1011 nativeImage, int index) {
        nativeImage.method_22619(0, 0, 0, 0, index * this.height, this.width, this.height, false, false, false, false);
    }

    public void baseAnimationTick() {
        var currentTime = System.currentTimeMillis();
        if (this.startingTime == 0) {
            this.startingTime = currentTime;
        }
        int delta = (int) (currentTime - this.startingTime);
        if (delta >= 40) {
            tickAnimation(currentTime);
        }
    }

    public void tickAnimation(long currentTime) {
        int frameTime = 40 * this.metadata.animationSpeed();
        long timeDiff = currentTime - this.startingTime;

        if (timeDiff > frameTime) {
            this.index++;
            this.startingTime = currentTime;
            timeDiff = 0;
            if (this.index >= this.metadata.frames()) {
                this.index = 0;
            }
            this.nextIndex = this.index + 1;
            if (this.nextIndex >= this.metadata.frames()) {
                this.nextIndex = 0;
            }

            if (!this.metadata.interpolate()) {
                this.method_23207();
                this.update(this.baseTexture, this.index);
            }
        }

        if (this.metadata.interpolate()) {
            var delta = Math.min(((double) timeDiff) / frameTime, 1);

            for (int x = 0; x < this.width; x++) {
                for (int y = 0; y < this.height; y++) {
                    int base = this.baseTexture.method_4315(x, y + this.index * this.height);
                    int next = this.baseTexture.method_4315(x, y + this.nextIndex * this.height);

                    int r = this.lerp(delta, next >> 16 & 0xFF, base >> 16 & 0xFF);
                    int g = this.lerp(delta, next >> 8 & 0xFF, base >> 8 & 0xFF);
                    int b = this.lerp(delta, next & 0xFF, base & 0xFF);
                    this.altTexture.method_4305(x, y, base & 0xFF000000 | r << 16 | g << 8 | b);
                }
            }

            this.method_23207();
            this.update(this.altTexture, 0);
        }
    }


    private int lerp(double delta, int to, int from) {
        return (int) (delta * (double) to + (1.0 - delta) * (double) from);
    }


    @Override
    public void method_4622() {
        if (this.animation) {
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(this::baseAnimationTick);
            } else {
                this.baseAnimationTick();
            }
        }
    }

    @Override
    public void close() {
        super.close();
        this.baseTexture.close();

        if (this.altTexture != null) {
            this.altTexture.close();
        }
    }
}
