package eu.pb4.polymer.resourcepack.impl.client.rendering;

import I;
import com.google.gson.Gson;
import com.mojang.blaze3d.systems.RenderSystem;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.resourcepack.impl.PolymerResourcePackImpl;
import eu.pb4.polymer.resourcepack.impl.PolymerResourcePackMod;
import eu.pb4.polymer.resourcepack.mixin.client.ArmorFeatureRendererAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map.Entry;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1060;
import net.minecraft.class_1741;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;


public record PolymerResourceReloader(class_1060 manager) implements class_3302 {
    private static final Gson GSON = new Gson();
    public static final class_2960 POLYMER_ARMOR_ID = CommonImplUtils.id("armors.json");

    @Override
    public CompletableFuture<Void> method_25931(class_4045 synchronizer, class_3300 manager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        return CompletableFuture.supplyAsync(() -> {
            PolymerResourcePackMod.ARMOR_TEXTURES.clear();
            PolymerResourcePackMod.hasArmorTextures = false;
            if (PolymerResourcePackImpl.USE_ALT_ARMOR_HANDLER) {
                var polymerArmor = manager.method_14486(POLYMER_ARMOR_ID);
                if (polymerArmor.isPresent()) {
                    try {
                        HashMap<String, String> data =  GSON.fromJson(new String(polymerArmor.get().method_14482().readAllBytes()), HashMap.class);

                        for (var entry : data.entrySet()) {
                            var id = class_2960.method_60654(entry.getValue());
                            var key = Integer.parseInt(entry.getKey());
                            PolymerResourcePackMod.ARMOR_TEXTURES.put(key, List.of(
                                    new class_1741.class_9196(id, "", false)
                            ));
                        }
                        PolymerResourcePackMod.hasArmorTextures = true;
                    } catch (Exception e) {
                        CommonImpl.LOGGER.warn("Invalid armors.json file!", e);
                    }
                }
            }
            return null;
        }, prepareExecutor).thenCompose(synchronizer::method_18352).thenAcceptAsync(v -> {
            if (PolymerResourcePackMod.hasArmorTextures) {
                for (var id : PolymerResourcePackMod.ARMOR_TEXTURES.values()) {
                    var first = id.getFirst().method_56693(false);
                    var second = id.getFirst().method_56693(true);
                    this.manager.method_4616(first, new PolymerArmorResourceTexture(first));
                    this.manager.method_4616(second, new PolymerArmorResourceTexture(second));
                }
            }
        }, (runnable) -> {
            Objects.requireNonNull(runnable);
            RenderSystem.recordRenderCall(runnable::run);
        });
    }

    @Override
    public String method_22322() {
        return "Polymer Resource Pack Resource Reloader";
    }
}
