package eu.pb4.polymer.resourcepack.mixin.compat.polymc;

import Z;
import eu.pb4.polymer.resourcepack.api.PolymerArmorModel;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import io.github.theepicblock.polymc.api.resource.ModdedResources;
import io.github.theepicblock.polymc.api.resource.PolyMcResourcePack;
import io.github.theepicblock.polymc.impl.misc.logging.SimpleLogger;
import io.github.theepicblock.polymc.impl.poly.item.ArmorColorManager;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import org.spongepowered.asm.mixin.*;

import javax.imageio.ImageIO;
import net.minecraft.class_1741;
import net.minecraft.class_1741.class_9196;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

@Pseudo
@Mixin(value = ArmorColorManager.class, remap = false)
public class polymc_ArmorColorManagerMixin {

    @Shadow @Final private Object2IntArrayMap<class_1741> material2Color;

    /**
     * @author Patbox
     * @reason v
     * I only needed it to copy textures, rest would collide with polymer's system
     * Maybe we should just extract shared rp stuff as it's own library?
     *
     * Original code by: TheEpicBlock
     */
    @Overwrite
    public void addToResourcePack(ModdedResources moddedResources, PolyMcResourcePack pack, SimpleLogger logger) {
        if (this.material2Color.isEmpty()) {
            return;
        }

        // Do this entire thing twice for both armor layers
        for (var bool : new boolean[] { false, true }) {
            // Collect all modded textures and calculate the size of the output
            for (var material : material2Color.keySet()) {
                for (var layer : material.comp_2302()) {
                    var id = layer.method_56693(bool);
                    try {
                        assert id != null;
                        var texturePath = id.method_12832().substring("textures/".length(), id.method_12832().length() - ".png".length());
                        var texture = moddedResources.getTexture(id.method_12836(), texturePath);
                        if (texture == null) {
                            logger.warn("Couldn't find armor texture for " + id + ", it won't display correctly when worn");
                            continue;
                        }

                        var moddedImage = ImageIO.read(texture.getTexture());
                        if (moddedImage == null) {
                            logger.warn("Couldn't read layer " + layer + " armor texture for " + id);
                            continue;
                        }

                        // Write the modded armor textures standalone
                        pack.setTexture(id.method_12836(), texturePath, moddedResources.getTexture(id.method_12836(), texturePath));
                    } catch (Throwable e) {
                        logger.error("Couldn't read armor texture " + id + " (layer #" + layer + ")");
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /**
     * @author Patbox
     * @reason See above
     */
    @Overwrite
    public boolean hasColor(int c) {
        return PolymerResourcePackUtils.isColorTaken(c);
    }

    /**
     * @author Patbox
     * @reason See above
     */
    @Overwrite
    public int getColorForMaterial(class_1741 material) {
        if (!material2Color.containsKey(material)) {
            var color = PolymerResourcePackUtils.requestArmor(class_7923.field_48976.method_47983(material));
            material2Color.put(material, color.color());
        }
        return material2Color.getInt(material);
    }
}
