/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.api;

import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.common.api.events.SimpleEvent;
import eu.pb4.polymer.common.impl.CommonClientConnectionExt;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.common.impl.CommonNetworkHandlerExt;
import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.resourcepack.api.PolymerArmorModel;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.api.ResourcePackCreator;
import eu.pb4.polymer.resourcepack.api.metadata.PackMcMeta;
import eu.pb4.polymer.resourcepack.impl.PolymerResourcePackImpl;
import eu.pb4.polymer.resourcepack.impl.compat.polymc.PolyMcHelpers;
import eu.pb4.polymer.resourcepack.impl.generation.DefaultRPBuilder;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public final class PolymerResourcePackUtils {
    private static final ResourcePackCreator INSTANCE = new ResourcePackCreator(PolymerResourcePackImpl.USE_OFFSET ? PolymerResourcePackImpl.OFFSET_VALUES : 1);
    public static final SimpleEvent<Consumer<ResourcePackBuilder>> RESOURCE_PACK_CREATION_EVENT = PolymerResourcePackUtils.INSTANCE.creationEvent;
    public static final SimpleEvent<Consumer<ResourcePackBuilder>> RESOURCE_PACK_AFTER_INITIAL_CREATION_EVENT = PolymerResourcePackUtils.INSTANCE.afterInitialCreationEvent;
    public static final SimpleEvent<Runnable> RESOURCE_PACK_FINISHED_EVENT = PolymerResourcePackUtils.INSTANCE.finishedEvent;
    private static boolean REQUIRED = PolymerResourcePackImpl.FORCE_REQUIRE;
    private static boolean DEFAULT_CHECK = true;

    private PolymerResourcePackUtils() {
    }

    public static PolymerModelData requestModel(class_1792 vanillaItem, class_2960 modelPath) {
        return INSTANCE.requestModel(vanillaItem, modelPath);
    }

    public static PolymerArmorModel requestArmor(class_2960 modelPath) {
        return INSTANCE.requestArmor(modelPath);
    }

    public static PolymerArmorModel requestArmor(class_6880<class_1741> material) {
        return INSTANCE.requestArmor(material);
    }

    public static boolean addModAssets(String modId) {
        return INSTANCE.addAssetSource(modId);
    }

    public static boolean addModAssetsWithoutCopy(String modId) {
        return INSTANCE.addAssetSourceWithoutCopy(modId);
    }

    public static boolean hasResources() {
        return !INSTANCE.isEmpty();
    }

    public static void markAsRequired() {
        REQUIRED = true;
    }

    public static boolean isRequired() {
        return REQUIRED;
    }

    public static boolean hasPack(@Nullable class_3222 player, UUID uuid) {
        return PolymerCommonUtils.hasResourcePack((class_3222)player, (UUID)uuid);
    }

    public static boolean hasMainPack(@Nullable class_3222 player) {
        return PolymerResourcePackUtils.hasPack(player, PolymerResourcePackUtils.getMainUuid());
    }

    public static Path getMainPath() {
        return PolymerResourcePackImpl.DEFAULT_PATH;
    }

    public static UUID getMainUuid() {
        return PolymerResourcePackImpl.MAIN_UUID;
    }

    public static void setPlayerStatus(class_3222 player, UUID uuid, boolean status) {
        if (player.field_13987 != null) {
            ((CommonClientConnectionExt)player.field_13987).polymerCommon$setResourcePack(uuid, status);
        }
    }

    public static boolean isColorTaken(int color) {
        return INSTANCE.isColorTaken(color);
    }

    public static List<PolymerModelData> getModelsFor(class_1792 item) {
        return INSTANCE.getModelsFor(item);
    }

    public static void disableDefaultCheck() {
        DEFAULT_CHECK = false;
        CommonImplUtils.disableResourcePackCheck = true;
    }

    public static boolean shouldCheckByDefault() {
        return DEFAULT_CHECK;
    }

    public static void ignoreNextDefaultCheck(class_3222 player) {
        ((CommonNetworkHandlerExt)player.field_13987).polymerCommon$setIgnoreNextResourcePack();
    }

    public static ResourcePackBuilder createBuilder(Path output) {
        return new DefaultRPBuilder(output);
    }

    public static boolean buildMain() {
        return PolymerResourcePackUtils.buildMain(PolymerResourcePackUtils.getMainPath());
    }

    public static boolean buildMain(Path output) {
        return PolymerResourcePackUtils.buildMain(output, s -> {});
    }

    public static boolean buildMain(Path output, Consumer<String> status) {
        try {
            return INSTANCE.build(output, status);
        }
        catch (Exception e) {
            CommonImpl.LOGGER.error("Couldn't create resource pack!");
            e.printStackTrace();
            return false;
        }
    }

    public static ResourcePackCreator getInstance() {
        return INSTANCE;
    }

    static {
        PolymerResourcePackUtils.INSTANCE.creationEvent.register(builder -> {
            Path path2;
            if (!PolymerResourcePackImpl.PREVENTED_PATHS.isEmpty()) {
                builder.addWriteConverter((path, data) -> {
                    for (String test : PolymerResourcePackImpl.PREVENTED_PATHS) {
                        if (!path.startsWith(test)) continue;
                        return null;
                    }
                    return data;
                });
            }
            if (Files.isDirectory(path2 = CommonImpl.getGameDir().resolve("polymer/source_assets"), new LinkOption[0])) {
                builder.copyFromPath(path2);
                try {
                    Path metafile = path2.resolve("pack.mcmeta");
                    if (Files.exists(metafile, new LinkOption[0])) {
                        PackMcMeta meta = PackMcMeta.fromString(Files.readString(metafile));
                        builder.getPackMcMetaBuilder().metadata(meta.pack());
                    }
                }
                catch (Throwable metafile) {
                    // empty catch block
                }
            }
            try {
                for (String field : PolymerResourcePackImpl.INCLUDE_MOD_IDS) {
                    builder.copyAssets(field);
                }
                Path gamePath = FabricLoader.getInstance().getGameDir();
                for (String field : PolymerResourcePackImpl.INCLUDE_ZIPS) {
                    Path zipPath = gamePath.resolve(field);
                    if (!Files.exists(zipPath, new LinkOption[0])) continue;
                    try {
                        FileSystem fs = FileSystems.newFileSystem(zipPath);
                        try {
                            for (Path root : fs.getRootDirectories()) {
                                builder.copyResourcePackFromPath(root, field);
                            }
                        }
                        finally {
                            if (fs == null) continue;
                            fs.close();
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (CompatStatus.POLYMC) {
                try {
                    Files.createDirectories(path2, new FileAttribute[0]);
                    PolyMcHelpers.importPolyMcResources(builder);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        PolymerResourcePackUtils.INSTANCE.afterInitialCreationEvent.register(builder -> {
            Path path = CommonImpl.getGameDir().resolve("polymer/override_assets");
            if (Files.isDirectory(path, new LinkOption[0])) {
                builder.copyFromPath(path);
                try {
                    Path metafile = path.resolve("pack.mcmeta");
                    if (Files.exists(metafile, new LinkOption[0])) {
                        PackMcMeta meta = PackMcMeta.fromString(Files.readString(metafile));
                        builder.getPackMcMetaBuilder().metadata(meta.pack());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }
}

