/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.api;

import eu.pb4.polymer.resourcepack.api.PolymerArmorModel;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.resourcepack.api.metadata.PackMcMeta;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.function.BiFunction;
import net.minecraft.class_8617;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface ResourcePackBuilder {
    public boolean addData(String var1, byte[] var2);

    public boolean copyAssets(String var1);

    public boolean copyFromPath(Path var1, String var2, boolean var3);

    default public boolean copyFromPath(Path path, String targetPrefix) {
        return this.copyFromPath(path, targetPrefix, true);
    }

    default public boolean copyFromPath(Path path) {
        return this.copyFromPath(path, "", true);
    }

    default public boolean copyFromPath(Path path, boolean override) {
        return this.copyFromPath(path, "", override);
    }

    default public boolean copyResourcePackFromPath(Path root) {
        return this.copyResourcePackFromPath(root, "__undefined__");
    }

    default public boolean copyResourcePackFromPath(Path root, String field) {
        try {
            Object str;
            Path packmcmeta;
            Path assets = root.resolve("assets");
            if (Files.exists(assets, new LinkOption[0])) {
                this.copyFromPath(assets, "assets/");
            }
            if (Files.exists(packmcmeta = root.resolve("pack.mcmeta"), new LinkOption[0])) {
                try {
                    str = Files.readString(packmcmeta);
                    this.addData("pack.mcmeta", ((String)str).getBytes(StandardCharsets.UTF_8));
                    PackMcMeta pack = PackMcMeta.fromString((String)str);
                    if (pack.overlays().isPresent()) {
                        for (class_8617.class_8618 ov : pack.overlays().get().comp_1577()) {
                            Path assets2 = root.resolve(ov.comp_1579());
                            if (!Files.exists(assets2, new LinkOption[0])) continue;
                            this.copyFromPath(assets2, ov.comp_1579() + "/");
                        }
                    }
                }
                catch (Throwable str2) {
                    // empty catch block
                }
            }
            str = Files.list(root);
            try {
                str.forEach(file -> {
                    try {
                        String name = file.getFileName().toString();
                        if (name.toLowerCase(Locale.ROOT).contains("license") || name.toLowerCase(Locale.ROOT).contains("licence")) {
                            this.addData("licenses/" + field.replace("/", "_").replace("\\", "_") + "/" + name, Files.readAllBytes(file));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
            }
            finally {
                if (str != null) {
                    str.close();
                }
            }
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public boolean addCustomModelData(PolymerModelData var1);

    public boolean addArmorModel(PolymerArmorModel var1);

    @Nullable
    public byte[] getData(String var1);

    @Nullable
    public byte[] getDataOrSource(String var1);

    public boolean addAssetsSource(String var1);

    public void addWriteConverter(BiFunction<String, byte[], @Nullable byte[]> var1);

    default public PackMcMeta.Builder getPackMcMetaBuilder() {
        return new PackMcMeta.Builder();
    }
}

