/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.impl;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.impl.PolymerResourcePackImpl;
import eu.pb4.polymer.resourcepack.impl.client.rendering.PolymerResourcePack;
import eu.pb4.polymer.resourcepack.impl.compat.polymc.PolyMcHelpers;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1741;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PolymerResourcePackMod
implements ModInitializer,
ClientModInitializer {
    public static boolean alreadyGeneration = false;
    public static final Int2ObjectMap<List<class_1741.class_9196>> ARMOR_TEXTURES = new Int2ObjectOpenHashMap();
    public static final List<class_1741.class_9196> LEATHER_OVERRIDE = List.of(new class_1741.class_9196(class_2960.method_60656((String)"vanilla_leather"), "", true), new class_1741.class_9196(class_2960.method_60656((String)"vanilla_leather"), "_overlay", false));
    public static boolean hasArmorTextures = false;

    public void onInitialize() {
        if (CompatStatus.POLYMC) {
            PolymerResourcePackUtils.markAsRequired();
            ServerLifecycleEvents.SERVER_STARTED.register(PolyMcHelpers::overrideCommand);
        }
        CommonImplUtils.registerCommands(x -> x.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"generate-pack").requires(CommonImplUtils.permission((String)"command.generate", (int)3))).executes(PolymerResourcePackMod::generateResources)));
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            CustomValue include = mod.getMetadata().getCustomValue("polymer:resource_pack_include");
            CustomValue require = mod.getMetadata().getCustomValue("polymer:resource_pack_require");
            if (include != null && include.getType() == CustomValue.CvType.BOOLEAN && include.getAsBoolean()) {
                PolymerResourcePackUtils.addModAssets(mod.getMetadata().getId());
            }
            if (require == null || require.getType() != CustomValue.CvType.BOOLEAN || !require.getAsBoolean()) continue;
            PolymerResourcePackUtils.markAsRequired();
        }
    }

    public void onInitializeClient() {
        PolymerResourcePack.setup();
    }

    public static int generateResources(CommandContext<class_2168> context) {
        PolymerResourcePackMod.generateAndCall(((class_2168)context.getSource()).method_9211(), false, x -> ((class_2168)context.getSource()).method_9226(() -> x, true), () -> {});
        return 1;
    }

    public static int generateResources(CommandContext<class_2168> context, Runnable runnable) {
        PolymerResourcePackMod.generateAndCall(((class_2168)context.getSource()).method_9211(), false, x -> ((class_2168)context.getSource()).method_9226(() -> x, true), runnable);
        return 1;
    }

    public static void generateAndCall(MinecraftServer server, boolean ignoreLock, Consumer<class_2561> messageConsumer, Runnable runnable) {
        if (alreadyGeneration && !ignoreLock) {
            messageConsumer.accept((class_2561)class_2561.method_43470((String)"[Polymer] Pack is already generating! Wait for it to finish..."));
            return;
        }
        alreadyGeneration = true;
        class_156.method_27958().execute(() -> {
            try {
                messageConsumer.accept((class_2561)class_2561.method_43470((String)"[Polymer] Starting resource pack generation..."));
                boolean success = PolymerResourcePackUtils.buildMain();
                server.execute(() -> {
                    alreadyGeneration = false;
                    if (success) {
                        messageConsumer.accept((class_2561)class_2561.method_43470((String)"[Polymer] Resource pack created successfully! You can find it in game folder as ").method_10852((class_2561)class_2561.method_43470((String)PolymerResourcePackImpl.FILE_NAME).method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)PolymerResourcePackUtils.getMainPath().toAbsolutePath().toString()))))));
                        runnable.run();
                    } else {
                        messageConsumer.accept((class_2561)class_2561.method_43470((String)"[Polymer] Found issues while creating resource pack! See logs above for more detail!").method_27692(class_124.field_1061));
                    }
                });
            }
            catch (Throwable e) {
                messageConsumer.accept((class_2561)class_2561.method_43470((String)"[Polymer] Found critical issues while creating resource pack! See logs above for more detail!").method_27692(class_124.field_1061));
                CommonImpl.LOGGER.error("Failed to generate the resource pack!", e);
                alreadyGeneration = false;
            }
        });
    }
}

