/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.resourcepack.impl.generation;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.common.api.events.SimpleEvent;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.api.PolymerArmorModel;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.resourcepack.api.metadata.PackMcMeta;
import eu.pb4.polymer.resourcepack.impl.ArmorTextureMetadata;
import eu.pb4.polymer.resourcepack.impl.generation.InternalRPBuilder;
import eu.pb4.polymer.resourcepack.mixin.accessors.ResourceFilterAccessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_6497;
import net.minecraft.class_7923;
import net.minecraft.class_8617;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DefaultRPBuilder
implements InternalRPBuilder {
    public static final Gson GSON = CommonImpl.GSON;
    private static final Comparator<JsonElement> CMD_COMPARATOR = Comparator.comparingInt(x -> {
        try {
            return x.getAsJsonObject().getAsJsonObject("predicate").get("custom_model_data").getAsInt();
        }
        catch (Throwable ignored) {
            return Integer.MAX_VALUE;
        }
    });
    public final SimpleEvent<Consumer<List<String>>> buildEvent = new SimpleEvent();
    private final Map<class_1792, JsonArray[]> customModels = new HashMap<class_1792, JsonArray[]>();
    private final TreeMap<String, byte[]> fileMap = new TreeMap();
    private final List<PolymerArmorModel> armors = new ArrayList<PolymerArmorModel>();
    private final Path outputPath;
    private final List<ModContainer> modsList = new ArrayList<ModContainer>();
    private final Map<class_2960, List<PolymerModelData>> customModelData = new HashMap<class_2960, List<PolymerModelData>>();
    private final Map<String, JsonArray> atlasDefinitions = new HashMap<String, JsonArray>();
    private final Map<String, JsonObject> objectMergeDefinitions = new HashMap<String, JsonObject>();
    private final List<Path> rootPaths = new ArrayList<Path>();
    private final List<BiFunction<String, byte[], @Nullable byte[]>> converters = new ArrayList<BiFunction<String, byte[], byte[]>>();
    private boolean hasVanilla;
    private final PackMcMeta.Builder packMetadata = new PackMcMeta.Builder();

    public DefaultRPBuilder(Path outputPath) {
        try {
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        }
        catch (Throwable e) {
            CommonImpl.LOGGER.warn("Couldn't create " + String.valueOf(outputPath.getParent()) + " directory!", e);
        }
        this.outputPath = outputPath;
        try {
            if (outputPath.toFile().exists()) {
                Files.deleteIfExists(outputPath);
            }
        }
        catch (Exception e) {
            CommonImpl.LOGGER.warn("Couldn't remove " + String.valueOf(outputPath) + " file!", (Throwable)e);
        }
    }

    private static Path getSelfPath(String path) {
        return ((ModContainer)FabricLoader.getInstance().getModContainer("polymer-resource-pack").get()).getPath(path);
    }

    @Override
    public boolean addData(String path, byte[] data) {
        try {
            if (path.endsWith(".json")) {
                if (path.equals("pack.mcmeta")) {
                    return this.addPackMcMeta(path, data, x -> {});
                }
                String[] split = path.split("/");
                if (split.length > 3 && split[0].equals("assets") && split[2].equals("atlases")) {
                    return this.addAtlasFile(path, data);
                }
                if (split.length > 3 && split[0].equals("assets") && split[2].equals("lang")) {
                    return this.addMergedObjectFile(path, data);
                }
            }
            this.fileMap.put(path, data);
            return true;
        }
        catch (Exception e) {
            CommonImpl.LOGGER.error("Something went wrong while adding raw data to path: " + path, (Throwable)e);
            return false;
        }
    }

    private boolean addPackMcMeta(String path, byte[] data, Consumer<String> overlayConsumer) {
        try {
            PackMcMeta pack = PackMcMeta.fromString(new String(data, StandardCharsets.UTF_8));
            this.addPackMcMeta(pack, overlayConsumer);
            return true;
        }
        catch (Throwable e) {
            CommonImpl.LOGGER.warn("Failed to load '{}'", (Object)path, (Object)e);
            return false;
        }
    }

    private void addPackMcMeta(PackMcMeta pack, Consumer<String> overlayConsumer) {
        pack.filter().ifPresent(x -> ((ResourceFilterAccessor)x).getBlocks().forEach(this.packMetadata::addFilter));
        pack.overlays().ifPresent(x -> x.comp_1577().forEach(o -> {
            overlayConsumer.accept(o.comp_1579());
            this.packMetadata.addOverlay((class_8617.class_8618)o);
        }));
        pack.language().ifPresent(x -> x.definitions().forEach(this.packMetadata::addLanguage));
    }

    private boolean addMergedObjectFile(String path, byte[] data) {
        try {
            JsonElement decode = JsonParser.parseString((String)new String(data, StandardCharsets.UTF_8));
            if (decode instanceof JsonObject) {
                JsonObject obj = (JsonObject)decode;
                JsonObject out = this.objectMergeDefinitions.computeIfAbsent(path, x -> new JsonObject());
                for (String key : obj.keySet()) {
                    out.add(key, obj.get(key));
                }
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean addAtlasFile(String path, byte[] data) {
        try {
            JsonElement decode = JsonParser.parseString((String)new String(data, StandardCharsets.UTF_8));
            if (decode instanceof JsonObject) {
                JsonObject obj = (JsonObject)decode;
                JsonArray list = obj.getAsJsonArray("sources");
                this.atlasDefinitions.computeIfAbsent(path, x -> new JsonArray()).addAll(list);
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean copyFromPath(Path basePath, String targetPrefix, boolean override) {
        try {
            if (Files.isSymbolicLink(basePath)) {
                basePath = Files.readSymbolicLink(basePath);
            }
            if (Files.isDirectory(basePath, new LinkOption[0])) {
                Path finalBasePath = basePath;
                try (Stream<Path> str = Files.walk(basePath, new FileVisitOption[0]);){
                    str.forEach(file -> {
                        Path relative = finalBasePath.relativize((Path)file);
                        String path = targetPrefix + relative.toString().replace("\\", "/");
                        if ((override || !this.fileMap.containsKey(path)) && Files.isRegularFile(file, new LinkOption[0])) {
                            try {
                                this.addData(path, Files.readAllBytes(file));
                            }
                            catch (IOException e) {
                                CommonImpl.LOGGER.warn("Failed to load '{}'", (Object)path, (Object)e);
                            }
                        }
                    });
                }
                return true;
            }
            if (Files.isRegularFile(basePath, new LinkOption[0])) {
                try (FileSystem fs = FileSystems.newFileSystem(basePath, Collections.emptyMap());){
                    fs.getRootDirectories().forEach(path -> this.copyFromPath((Path)path, targetPrefix, override));
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            CommonImpl.LOGGER.error("Something went wrong while copying data from: " + String.valueOf(basePath), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean copyAssets(String modId) {
        Optional mod = FabricLoader.getInstance().getModContainer(modId);
        if (mod.isPresent()) {
            ModContainer container = (ModContainer)mod.get();
            this.modsList.add(container);
            try {
                for (Path rootPaths : container.getRootPaths()) {
                    try (Stream<Path> str = Files.list(rootPaths);){
                        str.forEach(file -> {
                            try {
                                String name = file.getFileName().toString();
                                if (name.toLowerCase(Locale.ROOT).contains("license") || name.toLowerCase(Locale.ROOT).contains("licence")) {
                                    this.addData("licenses/" + modId + "/" + name, Files.readAllBytes(file));
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        });
                    }
                    catch (Throwable e) {
                        CommonImpl.LOGGER.warn("Failed while copying the license!", e);
                    }
                    ArrayList<String> baseToCopy = new ArrayList<String>();
                    baseToCopy.add("assets");
                    try {
                        Path packFile = rootPaths.resolve("pack.mcmeta");
                        if (Files.exists(packFile, new LinkOption[0])) {
                            PackMcMeta pack = PackMcMeta.fromString(Files.readString(packFile));
                            this.addPackMcMeta(pack, baseToCopy::add);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    for (String x : baseToCopy) {
                        Path assets = rootPaths.resolve(x);
                        if (!Files.exists(assets, new LinkOption[0])) continue;
                        Stream<Path> str = Files.walk(assets, new FileVisitOption[0]);
                        try {
                            str.forEach(file -> {
                                Path relative = assets.relativize((Path)file);
                                String path = relative.toString().replace("\\", "/");
                                if (Files.isRegularFile(file, new LinkOption[0])) {
                                    try {
                                        this.addData(x + "/" + path, Files.readAllBytes(file));
                                    }
                                    catch (IOException e) {
                                        CommonImpl.LOGGER.warn("Failed to load '{}'", (Object)(String.valueOf(assets) + "/" + path), (Object)e);
                                    }
                                }
                            });
                        }
                        finally {
                            if (str == null) continue;
                            str.close();
                        }
                    }
                }
                return true;
            }
            catch (Exception e) {
                CommonImpl.LOGGER.error("Something went wrong while copying assets of mod: " + modId, (Throwable)e);
                return false;
            }
        }
        CommonImpl.LOGGER.warn("Tried to copy assets from non existing mod " + modId);
        return false;
    }

    @Override
    public boolean addCustomModelData(PolymerModelData cmdInfo) {
        try {
            JsonArray jsonArray = this.getCustomModels(cmdInfo.item(), OverridePlace.CUSTOM_MODEL_DATA);
            this.customModelData.computeIfAbsent(class_7923.field_41178.method_10221((Object)cmdInfo.item()), x -> new ArrayList()).add(cmdInfo);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("model", CommonImplUtils.shortId((class_2960)cmdInfo.modelPath()));
            JsonObject predicateObject = new JsonObject();
            predicateObject.addProperty("custom_model_data", (Number)cmdInfo.value());
            jsonObject.add("predicate", (JsonElement)predicateObject);
            jsonArray.add((JsonElement)jsonObject);
            JsonObject modelObject = null;
            String modelPath = AssetPaths.model(cmdInfo.modelPath().method_12836(), cmdInfo.modelPath().method_12832() + ".json");
            if (this.fileMap.containsKey(modelPath)) {
                modelObject = JsonParser.parseString((String)new String(this.fileMap.get(modelPath), StandardCharsets.UTF_8)).getAsJsonObject();
            }
            if (modelObject != null && modelObject.has("overrides")) {
                JsonArray array = modelObject.getAsJsonArray("overrides");
                for (JsonElement element : array) {
                    JsonObject jsonObject2 = element.getAsJsonObject();
                    jsonObject2.get("predicate").getAsJsonObject().addProperty("custom_model_data", (Number)cmdInfo.value());
                    jsonArray.add((JsonElement)jsonObject2);
                }
            }
            return true;
        }
        catch (Exception e) {
            CommonImpl.LOGGER.error(String.format("Something went wrong while adding custom model data (%s) of %s for model %s", cmdInfo.value(), class_7923.field_41178.method_10221((Object)cmdInfo.item()), cmdInfo.modelPath().toString()), (Throwable)e);
            return false;
        }
    }

    public JsonArray getCustomModels(class_1792 item, OverridePlace place) {
        JsonArray json;
        if (!this.customModels.containsKey(item)) {
            JsonArray[] places = new JsonArray[OverridePlace.values().length];
            this.customModels.put(item, places);
        }
        if ((json = this.customModels.get(item)[place.ordinal()]) == null) {
            this.customModels.get((Object)item)[place.ordinal()] = json = new JsonArray();
        }
        return json;
    }

    @Override
    public boolean addArmorModel(PolymerArmorModel armorModel) {
        return this.armors.add(armorModel);
    }

    @Override
    public byte[] getData(String path) {
        return this.fileMap.get(path);
    }

    @Override
    @Nullable
    public byte[] getDataOrSource(String path) {
        if (this.fileMap.containsKey(path)) {
            return this.fileMap.get(path);
        }
        return this.getSourceData(path);
    }

    @Override
    public boolean addAssetsSource(String modId) {
        if (FabricLoader.getInstance().isModLoaded(modId)) {
            this.rootPaths.addAll(((ModContainer)FabricLoader.getInstance().getModContainer(modId).get()).getRootPaths());
            return true;
        }
        return false;
    }

    @Override
    public void addWriteConverter(BiFunction<String, byte[], @Nullable byte[]> converter) {
        this.converters.add(converter);
    }

    @Nullable
    private byte[] getSourceData(String path) {
        try {
            InputStream stream = this.getSourceStream(path);
            if (stream != null) {
                return stream.readAllBytes();
            }
        }
        catch (Throwable e) {
            CommonImpl.LOGGER.warn("Error occurred while getting data from vanilla jar!", e);
        }
        return null;
    }

    @Nullable
    private InputStream getSourceStream(String path) {
        try {
            if (!this.hasVanilla && path.startsWith("assets/minecraft/")) {
                this.rootPaths.add(PolymerCommonUtils.getClientJarRoot());
                this.hasVanilla = true;
            }
            for (Path rootPath : this.rootPaths) {
                Path entry = rootPath.resolve(path);
                if (!Files.exists(entry, new LinkOption[0])) continue;
                return Files.newInputStream(entry, new OpenOption[0]);
            }
        }
        catch (Exception e) {
            CommonImpl.LOGGER.warn("Error occurred while getting data from vanilla jar!", (Throwable)e);
        }
        return null;
    }

    @Override
    public CompletableFuture<Boolean> buildResourcePack() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ArrayList<Object> credits = new ArrayList<Object>();
                credits.add("");
                credits.add("  +-----------+");
                credits.add("  |           |");
                credits.add("  |   #   #   |");
                credits.add("  |           |");
                credits.add("  |   #   #   |");
                credits.add("  |    ###    |");
                credits.add("  |           |");
                credits.add("  |           |");
                credits.add("  +-----------+");
                credits.add("");
                credits.add("Generated with Polymer " + CommonImpl.VERSION);
                credits.add("");
                credits.add("Vanilla assets by Mojang Studios");
                credits.add("");
                credits.add("Contains assets from mods: ");
                for (ModContainer entry : this.modsList) {
                    StringBuilder stringBuilder = new StringBuilder(" - ").append(entry.getMetadata().getName()).append(" (").append(entry.getMetadata().getId()).append(")");
                    if (!entry.getMetadata().getLicense().isEmpty()) {
                        stringBuilder.append(" / License: ");
                        Iterator<Object> iter = entry.getMetadata().getLicense().iterator();
                        while (iter.hasNext()) {
                            stringBuilder.append((String)iter.next());
                            if (!iter.hasNext()) continue;
                            stringBuilder.append(", ");
                        }
                    }
                    entry.getMetadata().getContact().get("homepage").ifPresent(s -> b.append(" / Website: ").append((String)s));
                    entry.getMetadata().getContact().get("source").ifPresent(s -> b.append(" / Source: ").append((String)s));
                    credits.add(stringBuilder.toString());
                }
                credits.add("");
                credits.add("See licenses folder for more information!");
                credits.add("");
                this.buildEvent.invoke(c -> c.accept(credits));
                boolean bool = true;
                JsonObject jsonObject = new JsonObject();
                ArrayList<Map.Entry<class_2960, List<PolymerModelData>>> arrayList = new ArrayList<Map.Entry<class_2960, List<PolymerModelData>>>(this.customModelData.entrySet());
                arrayList.sort(Map.Entry.comparingByKey());
                for (Map.Entry entry : arrayList) {
                    JsonObject jsonObject2 = new JsonObject();
                    for (PolymerModelData model : (List)entry.getValue()) {
                        jsonObject2.addProperty(CommonImplUtils.shortId((class_2960)model.modelPath()), (Number)model.value());
                    }
                    jsonObject.add(CommonImplUtils.shortId((class_2960)((class_2960)entry.getKey())), (JsonElement)jsonObject2);
                }
                this.fileMap.put("assets/polymer/items.json", GSON.toJson((JsonElement)jsonObject).getBytes(StandardCharsets.UTF_8));
                for (class_1792 class_17922 : this.customModels.keySet()) {
                    class_2960 id = class_7923.field_41178.method_10221((Object)class_17922);
                    try {
                        class_2960 itemId = class_7923.field_41178.method_10221((Object)class_17922);
                        String baseModelPath = "assets/" + itemId.method_12836() + "/models/item/" + itemId.method_12832() + ".json";
                        JsonObject jsonObject2 = JsonParser.parseString((String)new String(this.getDataOrSource(baseModelPath), StandardCharsets.UTF_8)).getAsJsonObject();
                        if (jsonObject2.has("overrides")) {
                            JsonArray x = jsonObject2.getAsJsonArray("overrides");
                            JsonArray[] cmd = this.getCustomModels(class_17922, OverridePlace.CUSTOM_MODEL_DATA);
                            JsonArray existing = this.getCustomModels(class_17922, OverridePlace.EXISTING);
                            for (JsonElement element : x) {
                                JsonObject obj = element.getAsJsonObject();
                                if (obj.has("predicate") && obj.getAsJsonObject("predicate").has("custom_model_data")) {
                                    cmd.add((JsonElement)obj);
                                    continue;
                                }
                                existing.add((JsonElement)obj);
                            }
                        }
                        this.getCustomModels(class_17922, OverridePlace.CUSTOM_MODEL_DATA).asList().sort(CMD_COMPARATOR);
                        JsonArray jsonArray = new JsonArray();
                        for (JsonArray models : this.customModels.get(class_17922)) {
                            if (models == null) continue;
                            jsonArray.addAll(models);
                        }
                        jsonObject2.add("overrides", (JsonElement)jsonArray);
                        this.fileMap.put(baseModelPath, jsonObject2.toString().getBytes(StandardCharsets.UTF_8));
                    }
                    catch (Exception exception) {
                        CommonImpl.LOGGER.error("Something went wrong while saving model of " + String.valueOf(id), (Throwable)exception);
                        bool = false;
                    }
                }
                for (Map.Entry entry : this.atlasDefinitions.entrySet()) {
                    JsonObject obj = new JsonObject();
                    obj.add("sources", (JsonElement)entry.getValue());
                    this.fileMap.put((String)entry.getKey(), obj.toString().getBytes(StandardCharsets.UTF_8));
                }
                for (Map.Entry entry : this.objectMergeDefinitions.entrySet()) {
                    this.fileMap.put((String)entry.getKey(), ((JsonObject)entry.getValue()).toString().getBytes(StandardCharsets.UTF_8));
                }
                if (!this.armors.isEmpty()) {
                    int n;
                    int i;
                    credits.add("Armor texture support is based on https://github.com/Ancientkingg/fancyPants");
                    credits.add("");
                    ArrayList<ArmorData> list = new ArrayList<ArmorData>();
                    boolean bl = true;
                    HashMap<Integer, String> armorDataMap = new HashMap<Integer, String>();
                    for (PolymerArmorModel entry : this.armors) {
                        armorDataMap.put(entry.color(), CommonImplUtils.shortId((class_2960)entry.modelPath()));
                        try {
                            BufferedImage[] images = new BufferedImage[2];
                            ArmorTextureMetadata[] metadata = new ArmorTextureMetadata[2];
                            for (i = 0; i <= 1; ++i) {
                                BufferedImage bi = null;
                                Object path = "assets/" + entry.modelPath().method_12836() + "/textures/models/armor/" + entry.modelPath().method_12832() + "_layer_" + (i + 1) + ".png";
                                byte[] data = this.fileMap.get(path);
                                if (data == null) {
                                    try {
                                        InputStream stream = this.getSourceStream((String)path);
                                        if (stream != null) {
                                            bi = ImageIO.read(stream);
                                        }
                                    }
                                    catch (Exception stream) {}
                                } else {
                                    bi = ImageIO.read(new ByteArrayInputStream(data));
                                }
                                images[i] = bi;
                                path = AssetPaths.armorTexturePolymerMetadata(entry.modelPath(), i + 1);
                                data = this.fileMap.get(path);
                                if (data != null) {
                                    int finalI = i;
                                    ArmorTextureMetadata.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)new String(data))).result().ifPresentOrElse(r -> {
                                        metadata[finalI] = (ArmorTextureMetadata)r.getFirst();
                                    }, () -> {
                                        metadata[finalI] = ArmorTextureMetadata.DEFAULT;
                                    });
                                } else {
                                    metadata[i] = ArmorTextureMetadata.DEFAULT;
                                }
                                double scaleTest1 = (double)n / (double)metadata[i].scale();
                                if (scaleTest1 == Math.floor(scaleTest1)) continue;
                                double scaleTest2 = (double)metadata[i].scale() / (double)n;
                                if (scaleTest2 != Math.floor(scaleTest2)) {
                                    n *= metadata[i].scale();
                                    continue;
                                }
                                n = metadata[i].scale();
                            }
                            list.add(new ArmorData(entry.modelPath(), entry.color(), images, metadata));
                        }
                        catch (Throwable e3) {
                            CommonImpl.LOGGER.error("Error occurred when creating " + String.valueOf(entry.modelPath()) + " armor texture!", e3);
                        }
                    }
                    list.sort(Comparator.comparing(e -> -e.color()));
                    this.fileMap.put("assets/polymer/armors.json", GSON.toJson(armorDataMap).getBytes(StandardCharsets.UTF_8));
                    this.fileMap.put(AssetPaths.armorTexture(this.vId("vanilla_leather"), 1), this.getSourceData(AssetPaths.armorTexture(class_2960.method_60654((String)"leather"), 1)));
                    this.fileMap.put(AssetPaths.armorOverlayTexture(this.vId("vanilla_leather"), 1), this.getSourceData(AssetPaths.armorOverlayTexture(this.vId("leather"), 1)));
                    this.fileMap.put(AssetPaths.armorTexture(this.vId("vanilla_leather"), 2), this.getSourceData(AssetPaths.armorTexture(class_2960.method_60654((String)"leather"), 2)));
                    this.fileMap.put(AssetPaths.armorOverlayTexture(this.vId("vanilla_leather"), 2), this.getSourceData(AssetPaths.armorOverlayTexture(this.vId("leather"), 2)));
                    int[] nArray = new int[]{64 * n, 64 * n};
                    int[] height = new int[]{32 * n, 32 * n};
                    for (ArmorData entry : new ArrayList(list)) {
                        for (i = 0; i <= 1; ++i) {
                            BufferedImage image = entry.images()[i];
                            ArmorTextureMetadata metadata = entry.metadata()[i];
                            if (image == null) continue;
                            int scale = n / metadata.scale();
                            int newHeight = image.getHeight() * scale;
                            int newWidth = image.getWidth() * scale;
                            double check = (double)newWidth / (double)(64 * n);
                            if (check != Math.floor(check)) {
                                CommonImpl.LOGGER.warn("Invalid texture size for armor " + String.valueOf(entry.identifier()) + " (" + i + ")! Skipping...");
                                list.remove(entry);
                                continue;
                            }
                            height[i] = Math.max(height[i], newHeight);
                            int n2 = i;
                            nArray[n2] = nArray[n2] + newWidth;
                        }
                    }
                    BufferedImage[] image = new BufferedImage[]{new BufferedImage(nArray[0], height[0], 2), new BufferedImage(nArray[1], height[1], 2)};
                    int[] cWidth = new int[]{64 * n, 64 * n};
                    Graphics[] graphics = new Graphics[]{image[0].getGraphics(), image[1].getGraphics()};
                    try {
                        for (int i2 = 0; i2 <= 1; ++i2) {
                            BufferedImage tex = ImageIO.read(this.getSourceStream(AssetPaths.armorTexture(this.vId("leather"), i2 + 1)));
                            graphics[i2].drawImage(tex, 0, 0, tex.getWidth() * n, tex.getHeight() * n, null);
                            tex = ImageIO.read(this.getSourceStream(AssetPaths.armorOverlayTexture(this.vId("leather"), i2 + 1)));
                            graphics[i2].drawImage(tex, 0, 0, tex.getWidth() * n, tex.getHeight() * n, null);
                            graphics[i2].setColor(Color.WHITE);
                            graphics[i2].drawRect(0, 1, 0, 0);
                        }
                        for (ArmorData entry : list) {
                            for (int i3 = 0; i3 <= 1; ++i3) {
                                ArmorTextureMetadata metadata = entry.metadata()[i3];
                                int scale = n / metadata.scale();
                                BufferedImage tmpImage = entry.images()[i3];
                                if (tmpImage == null) continue;
                                graphics[i3].drawImage(tmpImage, cWidth[i3], 0, tmpImage.getWidth() * scale, tmpImage.getHeight() * scale, null);
                                graphics[i3].setColor(new Color(entry.color() | 0xFF000000));
                                graphics[i3].drawRect(cWidth[i3], 0, 0, 0);
                                if (metadata.frames() != 0 && metadata.animationSpeed() != 0 || metadata.interpolate()) {
                                    graphics[i3].setColor(new Color(metadata.frames(), metadata.animationSpeed(), metadata.interpolate() ? 1 : 0));
                                    graphics[i3].drawRect(cWidth[i3] + 1, 0, 0, 0);
                                }
                                if (metadata.emissivity() != 0) {
                                    graphics[i3].setColor(new Color(metadata.emissivity(), 0, 0));
                                    graphics[i3].drawRect(cWidth[i3] + 2, 0, 0, 0);
                                }
                                int n3 = i3;
                                cWidth[n3] = cWidth[n3] + tmpImage.getWidth() * scale;
                            }
                        }
                        for (int i4 = 0; i4 <= 1; ++i4) {
                            graphics[i4].dispose();
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            ImageIO.write((RenderedImage)image[i4], "png", out);
                            this.fileMap.put(AssetPaths.armorTexture(this.vId("leather"), i4 + 1), out.toByteArray());
                            out = new ByteArrayOutputStream();
                            ImageIO.write((RenderedImage)new BufferedImage(1, 1, 2), "png", out);
                            this.fileMap.put(AssetPaths.armorOverlayTexture(this.vId("leather"), i4 + 1), out.toByteArray());
                        }
                    }
                    catch (Throwable e4) {
                        CommonImpl.LOGGER.error("Error occurred when creating armor texture!", e4);
                    }
                    for (String string : new String[]{"fsh", "json", "vsh"}) {
                        this.fileMap.put("polymer_armor_shader/assets/minecraft/shaders/core/rendertype_armor_cutout_no_cull." + string, Files.readString(DefaultRPBuilder.getSelfPath("base-armor/rendertype_armor_cutout_no_cull." + string)).replace("${polymer_texture_resolution}", "" + 16 * n).getBytes(StandardCharsets.UTF_8));
                    }
                    this.packMetadata.addOverlay((class_6497<Integer>)new class_6497((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(35)), "polymer_armor_shader");
                }
                this.fileMap.put(AssetPaths.PACK_METADATA, this.packMetadata.build().asString().getBytes(StandardCharsets.UTF_8));
                if (!this.fileMap.containsKey(AssetPaths.PACK_ICON)) {
                    Path filePath = FabricLoader.getInstance().getGameDir().resolve("server-icon.png");
                    if (filePath.toFile().exists()) {
                        this.fileMap.put(AssetPaths.PACK_ICON, Files.readAllBytes(filePath));
                    } else {
                        this.fileMap.put(AssetPaths.PACK_ICON, Files.readAllBytes(DefaultRPBuilder.getSelfPath("assets/icon.png")));
                    }
                }
                this.fileMap.put("polymer-credits.txt", String.join((CharSequence)"\n", credits).getBytes(StandardCharsets.UTF_8));
                return bool &= this.writeSingleZip();
            }
            catch (Exception e5) {
                CommonImpl.LOGGER.error("Something went wrong while creating resource pack!", (Throwable)e5);
                return false;
            }
        });
    }

    @Override
    public PackMcMeta.Builder getPackMcMetaBuilder() {
        return this.packMetadata;
    }

    private boolean writeSingleZip() {
        try (ZipOutputStream outputStream = new ZipOutputStream(new FileOutputStream(this.outputPath.toFile()));){
            for (String path : this.fileMap.keySet().toArray(new String[0])) {
                ArrayList<String> split = new ArrayList<String>(List.of(path.split("/")));
                while (split.size() > 1) {
                    split.remove(split.size() - 1);
                    this.fileMap.put(String.join((CharSequence)"/", split) + "/", null);
                }
            }
            ArrayList<Map.Entry<String, byte[]>> sorted = new ArrayList<Map.Entry<String, byte[]>>(this.fileMap.entrySet());
            sorted.sort(Map.Entry.comparingByKey());
            for (Map.Entry<String, byte[]> entry : sorted) {
                String path;
                path = entry.getKey();
                byte[] outByte = entry.getValue();
                if (outByte != null) {
                    BiFunction<String, byte[], byte[]> conv;
                    Iterator<BiFunction<String, byte[], byte[]>> iterator = this.converters.iterator();
                    while (iterator.hasNext() && (outByte = (conv = iterator.next()).apply(path, outByte)) != null) {
                    }
                    if (outByte == null) continue;
                }
                ZipEntry zipEntry = new ZipEntry(path);
                zipEntry.setTime(0L);
                outputStream.putNextEntry(zipEntry);
                if (outByte != null) {
                    outputStream.write(outByte);
                }
                outputStream.closeEntry();
            }
        }
        catch (Throwable e) {
            CommonImpl.LOGGER.warn("Failed to write the zip file!", e);
            return false;
        }
        return true;
    }

    private class_2960 vId(String path) {
        return class_2960.method_60654((String)path);
    }

    public static enum OverridePlace {
        BEFORE_EXISTING,
        EXISTING,
        BEFORE_CUSTOM_MODEL_DATA,
        CUSTOM_MODEL_DATA,
        END;

    }

    private record ArmorData(class_2960 identifier, int color, BufferedImage[] images, ArmorTextureMetadata[] metadata) {
    }
}

