package eu.pb4.polymer.soundpatcher.impl;

import eu.pb4.polymer.common.api.ScopedOverride;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3902;

public class SoundRemapperImpl {
    public static final ThreadLocal<class_3902> IGNORE_PLAY_SOUND_EXCLUSION = new ThreadLocal<>();

    private static boolean ignored = true;
    private static final Map<class_2960, class_2960> REMAPPED_SOUND_IDS = new HashMap<>();
    public static final Set<class_2960> SOUND_EXCEPTION_IGNORER = new HashSet<>();

    public static class_3414 remap(class_3414 event) {
        if (ignored) {
            return event;
        }

        var id = REMAPPED_SOUND_IDS.get(event.comp_3319());
        if (id == null) {
            return event;
        }

        return new class_3414(id, event.comp_3320());
    }

    public static boolean register(class_2960 from, class_2960 to) {
        enable();
        if (REMAPPED_SOUND_IDS.containsKey(from) || ignored) {
            return false;
        }
        REMAPPED_SOUND_IDS.put(from, to);
        SOUND_EXCEPTION_IGNORER.add(from);
        return true;
    }

    public static void enable() {
        ignored = SoundPatchImpl.FORCE_DISABLE;
    }

    public static ScopedOverride ignorePlaySoundExclusion() {
        enable();
        if (SoundRemapperImpl.IGNORE_PLAY_SOUND_EXCLUSION.get() != null || ignored) {
            return ScopedOverride.NO_OP;
        }
        SoundRemapperImpl.IGNORE_PLAY_SOUND_EXCLUSION.set(class_3902.field_17274);
        return SoundRemapperImpl.IGNORE_PLAY_SOUND_EXCLUSION::remove;
    }

    public static boolean ignoreExceptions(class_3414 value) {
        if (ignored) {
            return false;
        }

        if (IGNORE_PLAY_SOUND_EXCLUSION.get() != null) {
            return true;
        }

        return SOUND_EXCEPTION_IGNORER.contains(value.comp_3319());
    }
}
