package eu.pb4.polymer.soundpatcher.api;

import eu.pb4.polymer.resourcepack.extras.api.format.sound.SoundsAsset;
import eu.pb4.polymer.soundpatcher.impl.SoundPatchImpl;
import eu.pb4.polymer.soundpatcher.impl.SoundRemapperImpl;
import eu.pb4.polymer.soundpatcher.impl.SoundResourceGenerator;
import eu.pb4.polymer.soundpatcher.impl.VanillaSoundJson;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public final class SoundPatcher {
    private SoundPatcher(){}
    public static void markAsIgnoringSoundExclusions(class_2498 soundGroup) {
        markAsIgnoringSoundExclusions(soundGroup.method_10594());
        markAsIgnoringSoundExclusions(soundGroup.method_10595());
        markAsIgnoringSoundExclusions(soundGroup.method_10593());
        markAsIgnoringSoundExclusions(soundGroup.method_10596());
        markAsIgnoringSoundExclusions(soundGroup.method_10598());
    }
    
    public static void markAsIgnoringSoundExclusions(class_3414 soundEvent) {
        markAsIgnoringSoundExclusions(soundEvent.comp_3319());
    }

    public static void markAsIgnoringSoundExclusions(class_2960 id) {
        SoundRemapperImpl.enable();
        SoundRemapperImpl.SOUND_EXCEPTION_IGNORER.add(id);
    }

    public static void convertAllVanillaBlockSoundsIntoServerSounds() {
        SoundPatchImpl.VANILLA_BLOCK_SOUNDS = true;
    }

    public static void convertIntoServerSound(class_3414 soundEvent) {
        convertIntoServerSound(soundEvent.comp_3319());
    }

    public static void convertIntoServerSound(class_2498 soundGroup) {
        convertIntoServerSound(soundGroup.method_10594());
        convertIntoServerSound(soundGroup.method_10595());
        convertIntoServerSound(soundGroup.method_10593());
        convertIntoServerSound(soundGroup.method_10596());
        convertIntoServerSound(soundGroup.method_10598());
    }

    public static SoundsAsset getVanillaSoundAsset() {
        return VanillaSoundJson.getSoundAsset();
    }

    public static void convertIntoServerSound(class_2960 soundEvent) {
        if (!soundEvent.method_12836().equals(class_2960.field_33381)) {
            throw new IllegalArgumentException("Only vanilla / minecraft sound events are supported, provided: " + soundEvent);
        }
        markAsIgnoringSoundExclusions(soundEvent);
        SoundRemapperImpl.enable();
        var id = class_2960.method_60655(SoundResourceGenerator.NAMESPACE, soundEvent.method_12836() + "." + soundEvent.method_12832());
        if (SoundRemapperImpl.register(soundEvent, id)) {
            SoundResourceGenerator.moveSoundEvent(soundEvent.method_12832(), id.method_12832());
        }
    }
}
