package eu.pb4.polymer.soundpatcher.mixin.block;

import eu.pb4.polymer.soundpatcher.api.SoundPatcher;
import eu.pb4.polymer.soundpatcher.impl.SoundPatchImpl;
import net.minecraft.class_2498;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_7923.class)
public class BuiltInRegistriesMixin {
    @Inject(method = "freeze", at = @At("TAIL"))
    private static void setupSoundsAsRequested(CallbackInfo ci) {
        if (!SoundPatchImpl.VANILLA_BLOCK_SOUNDS) {
            return;
        }


        for (var field : class_2498.class.getDeclaredFields()) {
            if (field.getType() == class_2498.class) {
                try {
                    SoundPatcher.convertIntoServerSound((class_2498) field.get(null));
                } catch (Throwable e) {
                    // ignored
                }
            }
        }

        for (var block : class_7923.field_41175) {
            var id = class_7923.field_41175.method_10221(block);
            if (id.method_12836().equals("minecraft")) {
                SoundPatcher.markAsIgnoringSoundExclusions(block.method_9564().method_26231());
            }
        }
    }
}
