/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.soundpatcher.impl;

import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.resourcepack.extras.api.format.sound.SoundsAsset;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.Nullable;

public class VanillaSoundJson {
    private static final String HASH = "123370fbb15bf1e85cf5038b3e8ca719ad391dfb";
    private static final String SOUNDS_URL = "https://resources.download.minecraft.net/" + "123370fbb15bf1e85cf5038b3e8ca719ad391dfb".substring(0, 2) + "/123370fbb15bf1e85cf5038b3e8ca719ad391dfb";
    private static final Path CHECKED_PATH = CommonImpl.getGameDir().resolve("polymer/cached_client_jars/123370fbb15bf1e85cf5038b3e8ca719ad391dfb_sounds.json");
    @Nullable
    private static SoundsAsset soundAsset = null;

    public static SoundsAsset getSoundAsset() {
        if (soundAsset != null) {
            return soundAsset;
        }
        soundAsset = VanillaSoundJson.createSoundAsset();
        return soundAsset;
    }

    private static SoundsAsset createSoundAsset() {
        if (CommonImpl.IS_CLIENT) {
            // empty if block
        }
        try {
            if (!Files.exists(CHECKED_PATH, new LinkOption[0])) {
                Files.createDirectories(CHECKED_PATH.getParent(), new FileAttribute[0]);
                CommonImpl.LOGGER.info("Downloading vanilla sounds.json...");
                URL url = new URL(SOUNDS_URL);
                URLConnection connection = url.openConnection();
                InputStream is = connection.getInputStream();
                Files.copy(is, CHECKED_PATH, new CopyOption[0]);
            }
            String data = Files.readString(CHECKED_PATH);
            return SoundsAsset.fromJson((String)data);
        }
        catch (Exception e) {
            CommonImpl.LOGGER.error("Couldn't retrieve vanilla sounds.json!", (Throwable)e);
            return SoundsAsset.builder().build();
        }
    }
}

