package eu.pb4.polymer.virtualentity.api;

import I;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.virtualentity.impl.EntityExt;
import eu.pb4.polymer.virtualentity.impl.compat.ImmersivePortalsUtils;
import eu.pb4.polymer.virtualentity.mixin.EntityPassengersSetS2CPacketAccessor;
import eu.pb4.polymer.virtualentity.mixin.SetCameraEntityS2CPacketAccessor;
import eu.pb4.polymer.virtualentity.mixin.accessors.EntityAccessor;
import eu.pb4.polymer.virtualentity.mixin.accessors.EntityPositionS2CPacketAccessor;
import eu.pb4.polymer.virtualentity.mixin.accessors.PlaySoundFromEntityS2CPacketAccessor;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2684;
import net.minecraft.class_2734;
import net.minecraft.class_2752;
import net.minecraft.class_2765;
import net.minecraft.class_2777;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.network.packet.s2c.play.*;
import org.jetbrains.annotations.Nullable;


public final class VirtualEntityUtils {
    private VirtualEntityUtils() {}
    public static int requestEntityId() {
        return EntityAccessor.getCURRENT_ID().incrementAndGet();
    }

    public static void addVirtualPassenger(class_1297 entity, int passengerId) {
        ((EntityExt) entity).polymerVE$getVirtualRidden().add(passengerId);
        ((EntityExt) entity).polymerVE$markVirtualRiddenDirty();
    }

    public static void addVirtualPassenger(class_1297 entity, int... passengerId) {
        for (var i : passengerId) {
            ((EntityExt) entity).polymerVE$getVirtualRidden().add(i);
        }
        ((EntityExt) entity).polymerVE$markVirtualRiddenDirty();
    }

    public static void removeVirtualPassenger(class_1297 entity, int passengerId) {
        ((EntityExt) entity).polymerVE$getVirtualRidden().rem(passengerId);
        ((EntityExt) entity).polymerVE$markVirtualRiddenDirty();
    }

    public static void removeVirtualPassenger(class_1297 entity, int... passengerId) {
        for (var i : passengerId) {
            ((EntityExt) entity).polymerVE$getVirtualRidden().rem(i);
        }
        ((EntityExt) entity).polymerVE$markVirtualRiddenDirty();
    }

    public static class_2734 createSetCameraEntityPacket(int entityId) {
        var packet = PolymerCommonUtils.createUnsafe(class_2734.class);
        var ac = (SetCameraEntityS2CPacketAccessor) packet;
        ac.setEntityId(entityId);
        return packet;
    }

    public static class_2765 createPlaySoundFromEntityPacket(int entityId, class_6880<class_3414> sound, class_3419 category, float volume, float pitch, long seed) {
        var packet = PolymerCommonUtils.createUnsafe(class_2765.class);
        var ac = (PlaySoundFromEntityS2CPacketAccessor) packet;
        ac.setEntityId(entityId);
        ac.setSound(sound);
        ac.setCategory(category);
        ac.setVolume(volume);
        ac.setPitch(pitch);
        ac.setSeed(seed);
        return packet;
    }


    @Nullable
    public static class_2596<class_2602> createMovePacket(int id, class_243 oldPos, class_243 newPos, boolean rotate, float yaw, float pitch) {
        var byteYaw = class_3532.method_15375(yaw * 256.0F / 360.0F);
        var bytePitch = class_3532.method_15375(pitch * 256.0F / 360.0F);
        boolean areDifferentEnough = oldPos.method_1020(newPos).method_1027() >= 7.62939453125E-6D;
        long newX = Math.round((newPos.field_1352 - oldPos.field_1352) * 4096.0D);
        long newY = Math.round((newPos.field_1351 - oldPos.field_1351) * 4096.0D);
        long newZ = Math.round((newPos.field_1350 - oldPos.field_1350) * 4096.0D);
        boolean bl5 = newX < -32768L || newX > 32767L || newY < -32768L || newY > 32767L || newZ < -32768L || newZ > 32767L;
        if (!bl5) {
            if ((!areDifferentEnough || !rotate)) {
                if (areDifferentEnough) {
                    return new class_2684.class_2685(id, (short) ((int) newX), (short) ((int) newY), (short) ((int) newZ), false);
                } else if (rotate) {
                    return new class_2684.class_2687(id, (byte) byteYaw, (byte) bytePitch, false);
                }
            } else {
                return new class_2684.class_2686(id, (short) ((int) newX), (short) ((int) newY), (short) ((int) newZ), (byte) byteYaw, (byte) bytePitch, false);
            }

            return null;
        } else {
            return createSimpleMovePacket(id, newPos, (byte) byteYaw, (byte) bytePitch);
        }
    }

    public static class_2596<class_2602> createSimpleMovePacket(int id, class_243 newPos, byte yaw, byte pitch) {
        var packet = PolymerCommonUtils.createUnsafe(class_2777.class);
        var accessor = (EntityPositionS2CPacketAccessor) packet;
        accessor.setId(id);
        accessor.setX(newPos.field_1352);
        accessor.setY(newPos.field_1351);
        accessor.setZ(newPos.field_1350);
        accessor.setOnGround(false);
        accessor.setPitch(pitch);
        accessor.setYaw(yaw);
        return packet;
    }

    public static class_2752 createRidePacket(int id, IntList list) {
        return createRidePacket(id, list.toIntArray());
    }

    public static class_2752 createRidePacket(int id, int[] list) {
        var packet = PolymerCommonUtils.createUnsafe(class_2752.class);
        ((EntityPassengersSetS2CPacketAccessor) packet).setEntityId(id);
        ((EntityPassengersSetS2CPacketAccessor) packet).setPassengerIds(list);
        return packet;
    }

    public static boolean isPlayerTracking(class_3222 player, class_2818 chunk) {
        if (CompatStatus.IMMERSIVE_PORTALS) {
            return ImmersivePortalsUtils.isPlayerTracking(player, chunk);
        }

        if (player.method_37908() != chunk.method_12200()) {
            return false;
        }

        return player.method_52372().method_52356(chunk.method_12004().field_9181, chunk.method_12004().field_9180);
    }

    /**
     * Purely for compatibility with immersive portals.
     */
    public static void wrapCallWithContext(class_3218 world, Runnable call) {
        if (CompatStatus.IMMERSIVE_PORTALS) {
            ImmersivePortalsUtils.callRedirected(world, call);
        } else {
            call.run();
        }
    }
}
