package eu.pb4.polymer.virtualentity.mixin.block;

import ;
import com.llamalad7.mixinextras.sugar.Local;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.impl.HolderAttachmentHolder;
import eu.pb4.polymer.virtualentity.impl.HolderHolder;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_3222;
import net.minecraft.class_3898;


@Mixin(class_3898.class)
public abstract class ServerChunkLoadingManagerMixin {

    @Inject(method = "handlePlayerAddedOrRemoved", at = @At("TAIL"))
    private void polymerVE$clearHolograms(class_3222 player, boolean added, CallbackInfo ci) {
        if (!added) {
            var holders = ((HolderHolder) player.field_13987).polymer$getHolders();
            if (!holders.isEmpty()) {
                var arr = holders.toArray(HolderHolder.ELEMENT_HOLDERS);
                for (int i = 0; i < arr.length; i++) {
                    var holder = arr[i];
                    if (holder.getAttachment() != null) {
                        holder.getAttachment().updateTracking(player.field_13987);
                    }
                }
            }
        }
    }

    @Inject(method = "method_60440", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/chunk/WorldChunk;setLoadedToWorld(Z)V", shift = At.Shift.AFTER))
    private void onChunkUnload(class_3193 chunkHolder, long l, CallbackInfo ci, @Local class_2818 chunk) {
        if (chunk instanceof HolderAttachmentHolder x) {
            var holders = x.polymerVE$getHolders();
            if (!holders.isEmpty()) {
                var arr = holders.toArray(HolderHolder.HOLDER_ATTACHMENTS);
                for (int i = 0; i < arr.length; i++) {
                    var holder = arr[i];
                    if (holder != null) {
                        holder.destroy();
                    }
                }
            }
        }
    }
}
