/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.virtualentity.api;

import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.virtualentity.impl.EntityExt;
import eu.pb4.polymer.virtualentity.impl.compat.ImmersivePortalsUtils;
import eu.pb4.polymer.virtualentity.mixin.EntityPassengersSetS2CPacketAccessor;
import eu.pb4.polymer.virtualentity.mixin.SetCameraEntityS2CPacketAccessor;
import eu.pb4.polymer.virtualentity.mixin.accessors.EntityAccessor;
import eu.pb4.polymer.virtualentity.mixin.accessors.EntityPositionS2CPacketAccessor;
import eu.pb4.polymer.virtualentity.mixin.accessors.PlaySoundFromEntityS2CPacketAccessor;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2684;
import net.minecraft.class_2734;
import net.minecraft.class_2752;
import net.minecraft.class_2765;
import net.minecraft.class_2777;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public final class VirtualEntityUtils {
    private VirtualEntityUtils() {
    }

    public static int requestEntityId() {
        return EntityAccessor.getCURRENT_ID().incrementAndGet();
    }

    public static void addVirtualPassenger(class_1297 entity, int passengerId) {
        ((EntityExt)entity).polymerVE$getVirtualRidden().add(passengerId);
        ((EntityExt)entity).polymerVE$markVirtualRiddenDirty();
    }

    public static void addVirtualPassenger(class_1297 entity, int ... passengerId) {
        for (int i : passengerId) {
            ((EntityExt)entity).polymerVE$getVirtualRidden().add(i);
        }
        ((EntityExt)entity).polymerVE$markVirtualRiddenDirty();
    }

    public static void removeVirtualPassenger(class_1297 entity, int passengerId) {
        ((EntityExt)entity).polymerVE$getVirtualRidden().rem(passengerId);
        ((EntityExt)entity).polymerVE$markVirtualRiddenDirty();
    }

    public static void removeVirtualPassenger(class_1297 entity, int ... passengerId) {
        for (int i : passengerId) {
            ((EntityExt)entity).polymerVE$getVirtualRidden().rem(i);
        }
        ((EntityExt)entity).polymerVE$markVirtualRiddenDirty();
    }

    public static class_2734 createSetCameraEntityPacket(int entityId) {
        class_2734 packet = (class_2734)PolymerCommonUtils.createUnsafe(class_2734.class);
        SetCameraEntityS2CPacketAccessor ac = (SetCameraEntityS2CPacketAccessor)packet;
        ac.setEntityId(entityId);
        return packet;
    }

    public static class_2765 createPlaySoundFromEntityPacket(int entityId, class_6880<class_3414> sound, class_3419 category, float volume, float pitch, long seed) {
        class_2765 packet = (class_2765)PolymerCommonUtils.createUnsafe(class_2765.class);
        PlaySoundFromEntityS2CPacketAccessor ac = (PlaySoundFromEntityS2CPacketAccessor)packet;
        ac.setEntityId(entityId);
        ac.setSound(sound);
        ac.setCategory(category);
        ac.setVolume(volume);
        ac.setPitch(pitch);
        ac.setSeed(seed);
        return packet;
    }

    @Nullable
    public static class_2596<class_2602> createMovePacket(int id, class_243 oldPos, class_243 newPos, boolean rotate, float yaw, float pitch) {
        boolean bl5;
        int byteYaw = class_3532.method_15375((float)(yaw * 256.0f / 360.0f));
        int bytePitch = class_3532.method_15375((float)(pitch * 256.0f / 360.0f));
        boolean areDifferentEnough = oldPos.method_1020(newPos).method_1027() >= 7.62939453125E-6;
        long newX = Math.round((newPos.field_1352 - oldPos.field_1352) * 4096.0);
        long newY = Math.round((newPos.field_1351 - oldPos.field_1351) * 4096.0);
        long newZ = Math.round((newPos.field_1350 - oldPos.field_1350) * 4096.0);
        boolean bl = bl5 = newX < -32768L || newX > 32767L || newY < -32768L || newY > 32767L || newZ < -32768L || newZ > 32767L;
        if (!bl5) {
            if (!areDifferentEnough || !rotate) {
                if (areDifferentEnough) {
                    return new class_2684.class_2685(id, (short)newX, (short)newY, (short)newZ, false);
                }
                if (rotate) {
                    return new class_2684.class_2687(id, (byte)byteYaw, (byte)bytePitch, false);
                }
            } else {
                return new class_2684.class_2686(id, (short)newX, (short)newY, (short)newZ, (byte)byteYaw, (byte)bytePitch, false);
            }
            return null;
        }
        return VirtualEntityUtils.createSimpleMovePacket(id, newPos, (byte)byteYaw, (byte)bytePitch);
    }

    public static class_2596<class_2602> createSimpleMovePacket(int id, class_243 newPos, byte yaw, byte pitch) {
        class_2777 packet = (class_2777)PolymerCommonUtils.createUnsafe(class_2777.class);
        EntityPositionS2CPacketAccessor accessor = (EntityPositionS2CPacketAccessor)packet;
        accessor.setId(id);
        accessor.setX(newPos.field_1352);
        accessor.setY(newPos.field_1351);
        accessor.setZ(newPos.field_1350);
        accessor.setOnGround(false);
        accessor.setPitch(pitch);
        accessor.setYaw(yaw);
        return packet;
    }

    public static class_2752 createRidePacket(int id, IntList list) {
        return VirtualEntityUtils.createRidePacket(id, list.toIntArray());
    }

    public static class_2752 createRidePacket(int id, int[] list) {
        class_2752 packet = (class_2752)PolymerCommonUtils.createUnsafe(class_2752.class);
        ((EntityPassengersSetS2CPacketAccessor)packet).setEntityId(id);
        ((EntityPassengersSetS2CPacketAccessor)packet).setPassengerIds(list);
        return packet;
    }

    public static boolean isPlayerTracking(class_3222 player, class_2818 chunk) {
        if (CompatStatus.IMMERSIVE_PORTALS) {
            return ImmersivePortalsUtils.isPlayerTracking(player, chunk);
        }
        if (player.method_37908() != chunk.method_12200()) {
            return false;
        }
        return player.method_52372().method_52356(chunk.method_12004().field_9181, chunk.method_12004().field_9180);
    }

    public static void wrapCallWithContext(class_3218 world, Runnable call) {
        if (CompatStatus.IMMERSIVE_PORTALS) {
            ImmersivePortalsUtils.callRedirected(world, call);
        } else {
            call.run();
        }
    }
}

