/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.virtualentity.api.attachment;

import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.impl.SimpleUpdateType;
import eu.pb4.polymer.virtualentity.impl.VoidUpdateType;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;

public interface HolderAttachment {
    public ElementHolder holder();

    public void destroy();

    public class_243 getPos();

    public class_3218 getWorld();

    public void updateCurrentlyTracking(Collection<class_3244> var1);

    public void updateTracking(class_3244 var1);

    default public void startWatching(class_3222 handler) {
        if (this.holder().getAttachment() == this) {
            if (CompatStatus.IMMERSIVE_PORTALS) {
                VirtualEntityUtils.wrapCallWithContext(this.getWorld(), () -> this.holder().startWatching(handler));
            } else {
                this.holder().startWatching(handler);
            }
        }
    }

    default public void startWatching(class_3244 handler) {
        if (this.holder().getAttachment() == this) {
            if (CompatStatus.IMMERSIVE_PORTALS) {
                VirtualEntityUtils.wrapCallWithContext(this.getWorld(), () -> this.holder().startWatching(handler));
            } else {
                this.holder().startWatching(handler);
            }
        }
    }

    default public void startWatchingExtraPackets(class_3244 handler, Consumer<class_2596<class_2602>> packetConsumer) {
    }

    default public void stopWatching(class_3222 handler) {
        if (this.holder().getAttachment() == this) {
            if (CompatStatus.IMMERSIVE_PORTALS) {
                VirtualEntityUtils.wrapCallWithContext(this.getWorld(), () -> this.holder().stopWatching(handler));
            } else {
                this.holder().stopWatching(handler);
            }
        }
    }

    default public void stopWatching(class_3244 handler) {
        if (this.holder().getAttachment() == this) {
            if (CompatStatus.IMMERSIVE_PORTALS) {
                VirtualEntityUtils.wrapCallWithContext(this.getWorld(), () -> this.holder().stopWatching(handler));
            } else {
                this.holder().stopWatching(handler);
            }
        }
    }

    default public void tick() {
        if (this.holder().getAttachment() == this) {
            if (CompatStatus.IMMERSIVE_PORTALS) {
                VirtualEntityUtils.wrapCallWithContext(this.getWorld(), () -> this.holder().tick());
            } else {
                this.holder().tick();
            }
        }
    }

    default public boolean shouldTick() {
        return true;
    }

    default public boolean canUpdatePosition() {
        return true;
    }

    public static interface UpdateType {
        public static final UpdateType POSITION = UpdateType.of("BlockState");

        public static UpdateType of() {
            return new VoidUpdateType();
        }

        public static UpdateType of(String type) {
            return new SimpleUpdateType(type);
        }
    }
}

