/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.sgui.api.gui;

import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.BaseSlotGui;
import eu.pb4.sgui.mixin.ScreenHandlerAccessor;
import eu.pb4.sgui.virtual.SguiScreenHandlerFactory;
import eu.pb4.sgui.virtual.inventory.VirtualScreenHandler;
import eu.pb4.sgui.virtual.inventory.VirtualSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.class_10298;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2649;
import net.minecraft.class_2651;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_3944;
import net.minecraft.class_8042;

public class SimpleGui
extends BaseSlotGui {
    protected final int width;
    protected final int height;
    protected final class_3917<?> type;
    private final boolean includePlayer;
    private final int sizeCont;
    protected boolean lockPlayerInventory = false;
    protected VirtualScreenHandler screenHandler = null;
    protected int syncId = -1;
    protected boolean hasRedirects = false;
    private class_2561 title = null;

    public SimpleGui(class_3917<?> type, class_3222 player, boolean manipulatePlayerSlots) {
        super(player, GuiHelpers.getHeight(type) * GuiHelpers.getWidth(type) + (manipulatePlayerSlots ? 36 : 0));
        this.height = GuiHelpers.getHeight(type);
        this.width = GuiHelpers.getWidth(type);
        this.type = type;
        this.sizeCont = this.width * this.height;
        this.includePlayer = manipulatePlayerSlots;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setSlot(int index, GuiElementInterface element) {
        super.setSlot(index, element);
        if (this.isOpen() && this.autoUpdate) {
            this.screenHandler.setSlot(index, new VirtualSlot(this, index, 0, 0));
        }
    }

    @Override
    public void setSlotRedirect(int index, class_1735 slot) {
        super.setSlotRedirect(index, slot);
        if (this.isOpen() && this.autoUpdate) {
            this.screenHandler.setSlot(index, slot);
        }
    }

    @Override
    public void clearSlot(int index) {
        super.clearSlot(index);
        this.hasRedirects = true;
        if (this.isOpen() && this.autoUpdate) {
            this.screenHandler.setSlot(index, new VirtualSlot(this, index, 0, 0));
        }
    }

    @Override
    public boolean isOpen() {
        return this.screenHandler != null && this.screenHandler == this.player.field_7512;
    }

    @Override
    public class_2561 getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(class_2561 title) {
        this.title = title;
        if (this.isOpen()) {
            int i;
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(new class_3944(this.syncId, this.type, title));
            list.add(new class_2649(this.syncId, this.screenHandler.method_37421(), (List)this.screenHandler.method_7602(), this.screenHandler.method_34255()));
            for (i = 0; i < this.properties.size(); ++i) {
                list.add(new class_2651(this.syncId, i, this.properties.getInt(i)));
            }
            this.player.field_13987.method_14364((class_2596)new class_8042(list));
            for (i = 0; i < this.screenHandler.field_7761.size(); ++i) {
                this.screenHandler.method_34245(i, ((class_1735)this.screenHandler.field_7761.get(i)).method_7677().method_7972());
            }
            ((ScreenHandlerAccessor)((Object)this.screenHandler)).getRemoteCarried().method_68806(this.screenHandler.method_34255());
        }
    }

    @Override
    public boolean getAutoUpdate() {
        return this.autoUpdate;
    }

    @Override
    public void setAutoUpdate(boolean value) {
        this.autoUpdate = value;
    }

    @Override
    public boolean isIncludingPlayer() {
        return this.includePlayer;
    }

    @Override
    public int getVirtualSize() {
        return this.sizeCont;
    }

    @Override
    public boolean isRedirectingSlots() {
        return this.hasRedirects;
    }

    protected boolean sendGui() {
        this.reOpen = true;
        OptionalInt temp = this.player.method_17355(SguiScreenHandlerFactory.ofDefault(this));
        this.reOpen = false;
        if (temp.isPresent()) {
            this.syncId = temp.getAsInt();
            if (this.player.field_7512 instanceof VirtualScreenHandler) {
                this.screenHandler = (VirtualScreenHandler)this.player.field_7512;
                return true;
            }
        }
        return false;
    }

    public void onCraftRequest(class_10298 recipe, boolean shift) {
    }

    @Override
    public class_3917<?> getType() {
        return this.type;
    }

    @Override
    public boolean open() {
        if (this.player.method_14239() || this.isOpen()) {
            return false;
        }
        this.beforeOpen();
        this.onOpen();
        this.sendGui();
        return this.isOpen();
    }

    public class_1703 openAsScreenHandler(int syncId, class_1661 playerInventory, class_1657 player) {
        if (this.player.method_14239() || player != this.player || this.isOpen()) {
            return null;
        }
        this.beforeOpen();
        this.onOpen();
        this.screenHandler = new VirtualScreenHandler(this.getType(), syncId, this, player);
        return this.screenHandler;
    }

    @Override
    public void close(boolean screenHandlerIsClosed) {
        if ((this.isOpen() || screenHandlerIsClosed) && !this.reOpen) {
            if (!screenHandlerIsClosed && this.player.field_7512 == this.screenHandler) {
                this.player.method_7346();
                this.screenHandler = null;
            }
            this.player.field_7512.method_34252();
            this.onClose();
        } else {
            this.reOpen = false;
        }
    }

    @Override
    public boolean getLockPlayerInventory() {
        return this.lockPlayerInventory || this.includePlayer;
    }

    @Override
    public void setLockPlayerInventory(boolean value) {
        this.lockPlayerInventory = value;
    }

    @Override
    public int getSyncId() {
        return this.syncId;
    }

    @Deprecated
    public void sendProperty(int property, int value) {
        this.player.field_13987.method_14364((class_2596)new class_2651(this.syncId, property, value));
    }

    @Override
    @Deprecated
    public void setSlot(int index, class_1799 itemStack, GuiElementInterface.ItemClickCallback callback) {
        this.setSlot(index, new GuiElement(itemStack, callback));
    }

    @Override
    @Deprecated
    public void addSlot(class_1799 itemStack, GuiElementInterface.ItemClickCallback callback) {
        this.addSlot(new GuiElement(itemStack, callback));
    }
}

