/*
 * Decompiled with CFR 0.152.
 */
package io.github.ladysnake.pal;

import io.github.ladysnake.pal.PlayerAbility;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public final class AbilitySource
implements Comparable<AbilitySource> {
    public static final int FREE = 2000;
    public static final int RENEWABLE = 1000;
    public static final int DEFAULT = 0;
    public static final int CONSUMABLE = -1000;
    private final class_2960 id;
    private final int priority;

    AbilitySource(class_2960 id, int priority) {
        this.id = id;
        this.priority = priority;
    }

    public class_2960 getId() {
        return this.id;
    }

    public int getPriority() {
        return this.priority;
    }

    public void grantTo(class_1657 player, PlayerAbility ability) {
        ability.getTracker(player).addSource(this);
    }

    public void revokeFrom(class_1657 player, PlayerAbility ability) {
        ability.getTracker(player).removeSource(this);
    }

    public boolean grants(class_1657 player, PlayerAbility ability) {
        return ability.getTracker(player).isGrantedBy(this);
    }

    public boolean isActivelyGranting(class_1657 player, PlayerAbility ability) {
        return ability.getTracker(player).getActiveSource() == this;
    }

    @Override
    public int compareTo(@NotNull AbilitySource o) {
        int priorityOrder = Integer.compare(this.priority, o.priority);
        return priorityOrder != 0 ? priorityOrder : this.id.method_12833(o.id);
    }

    public String toString() {
        return "AbilitySource@" + String.valueOf(this.id) + "+" + this.priority;
    }
}

