/*
 * Decompiled with CFR 0.152.
 */
package io.github.ladysnake.pal;

import com.google.common.base.Suppliers;
import io.github.ladysnake.pal.AbilitySource;
import io.github.ladysnake.pal.AbilityTracker;
import io.github.ladysnake.pal.PlayerAbility;
import io.github.ladysnake.pal.VanillaAbilities;
import io.github.ladysnake.pal.impl.PalInternals;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class Pal
implements ModInitializer {
    public static void grantAbility(class_1657 player, PlayerAbility ability, AbilitySource reason) {
        reason.grantTo(player, ability);
    }

    public static void revokeAbility(class_1657 player, PlayerAbility ability, AbilitySource reason) {
        reason.revokeFrom(player, ability);
    }

    public static AbilitySource getAbilitySource(String namespace, String name) {
        return Pal.getAbilitySource(class_2960.method_60655((String)namespace, (String)name));
    }

    public static AbilitySource getAbilitySource(class_2960 abilitySourceId) {
        return PalInternals.registerSource(abilitySourceId, null, AbilitySource::new);
    }

    public static AbilitySource getAbilitySource(class_2960 abilitySourceId, int priority) {
        return PalInternals.registerSource(abilitySourceId, priority, AbilitySource::new);
    }

    public static PlayerAbility registerAbility(String namespace, String path, BiFunction<PlayerAbility, class_1657, AbilityTracker> factory) {
        return Pal.registerAbility(class_2960.method_60655((String)namespace, (String)path), factory);
    }

    public static PlayerAbility registerAbility(class_2960 abilityId, BiFunction<PlayerAbility, class_1657, AbilityTracker> factory) {
        return PalInternals.registerAbility(new PlayerAbility(Objects.requireNonNull(abilityId), Objects.requireNonNull(factory)));
    }

    public static boolean isAbilityRegistered(@Nullable class_2960 abilityId) {
        return PalInternals.isAbilityRegistered(abilityId);
    }

    public static Supplier<PlayerAbility> provideRegisteredAbility(class_2960 abilityId) {
        Objects.requireNonNull(abilityId, "abilityId cannot be null");
        return Suppliers.memoize(() -> Objects.requireNonNull(PalInternals.getAbility(abilityId), String.valueOf(abilityId) + " has not been registered"));
    }

    public void onInitialize() {
        new VanillaAbilities();
        PalInternals.loadConfig();
    }
}

