/*
 * Decompiled with CFR 0.152.
 */
package io.github.ladysnake.pal;

import io.github.ladysnake.pal.AbilityTracker;
import io.github.ladysnake.pal.PlayerAbilityUpdatedCallback;
import io.github.ladysnake.pal.impl.PalInternals;
import io.github.ladysnake.pal.impl.PlayerAbilityView;
import java.util.function.BiFunction;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public final class PlayerAbility {
    @ApiStatus.Internal
    final Event<PlayerAbilityUpdatedCallback> updateEvent = PalInternals.createUpdateEvent();
    private final BiFunction<PlayerAbility, class_1657, AbilityTracker> trackerFactory;
    private final class_2960 id;

    @ApiStatus.Internal
    PlayerAbility(class_2960 id, BiFunction<PlayerAbility, class_1657, AbilityTracker> trackerFactory) {
        this.id = id;
        this.trackerFactory = trackerFactory;
    }

    public AbilityTracker getTracker(class_1657 player) {
        return PlayerAbilityView.of(player).get(this);
    }

    public boolean isEnabledFor(class_1657 player) {
        return this.getTracker(player).isEnabled();
    }

    @Contract(value="_ -> new")
    @ApiStatus.Internal
    public AbilityTracker createTracker(class_1657 player) {
        return this.trackerFactory.apply(this, player);
    }

    public class_2960 getId() {
        return this.id;
    }

    public String toString() {
        return "PlayerAbility@" + String.valueOf(this.id);
    }
}

