/*
 * Decompiled with CFR 0.152.
 */
package io.github.ladysnake.pal;

import com.mojang.serialization.Codec;
import io.github.ladysnake.pal.AbilitySource;
import io.github.ladysnake.pal.AbilityTracker;
import io.github.ladysnake.pal.PlayerAbility;
import io.github.ladysnake.pal.PlayerAbilityEnableCallback;
import io.github.ladysnake.pal.PlayerAbilityUpdatedCallback;
import io.github.ladysnake.pal.impl.PalInternals;
import io.github.ladysnake.pal.impl.VanillaAbilityTracker;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_2960;

public class SimpleAbilityTracker
implements AbilityTracker {
    protected final class_1657 player;
    protected final SortedSet<AbilitySource> abilitySources = new TreeSet<AbilitySource>();
    protected final PlayerAbility ability;

    public SimpleAbilityTracker(PlayerAbility ability, class_1657 player) {
        this.ability = ability;
        this.player = player;
    }

    @Override
    public void addSource(AbilitySource abilitySource) {
        boolean wasEmpty = this.abilitySources.isEmpty();
        if (this.abilitySources.add(abilitySource) && wasEmpty && ((PlayerAbilityEnableCallback)PlayerAbilityEnableCallback.EVENT.invoker()).allow(this.player, this.ability, abilitySource)) {
            this.updateState(true);
            this.sync();
        }
    }

    @Override
    public void removeSource(AbilitySource abilitySource) {
        if (this.abilitySources.remove(abilitySource) && this.abilitySources.isEmpty()) {
            this.updateState(false);
            this.sync();
        }
    }

    @Override
    public boolean isGrantedBy(AbilitySource abilitySource) {
        return this.abilitySources.contains(abilitySource);
    }

    @Override
    public AbilitySource getActiveSource() {
        return this.abilitySources.last();
    }

    @Override
    public void refresh(boolean syncVanilla) {
        this.updateState(this.shouldBeEnabled());
        if (syncVanilla || !(this instanceof VanillaAbilityTracker)) {
            this.sync();
        }
    }

    protected boolean shouldBeEnabled() {
        for (AbilitySource abilitySource : this.abilitySources) {
            if (!((PlayerAbilityEnableCallback)PlayerAbilityEnableCallback.EVENT.invoker()).allow(this.player, this.ability, abilitySource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void save(class_11372 view) {
        class_11372.class_11373 list = view.method_71467("ability_sources", (Codec)Codec.STRING);
        for (AbilitySource abilitySource : this.abilitySources) {
            list.method_71484((Object)abilitySource.getId().toString());
        }
    }

    @Override
    public void load(class_11368 view) {
        class_11368.class_11369 list = view.method_71437("ability_sources", (Codec)Codec.STRING);
        for (String string : list) {
            AbilitySource source = PalInternals.getSource(class_2960.method_12829((String)string));
            if (source != null) {
                this.addSource(source);
                continue;
            }
            PalInternals.LOGGER.warn("Unknown ability source {} attached to {} for {}", (Object)string, (Object)this.player, (Object)this.ability);
        }
    }

    protected void updateState(boolean enabled) {
        ((PlayerAbilityUpdatedCallback)PlayerAbilityUpdatedCallback.event(this.ability).invoker()).onAbilityUpdated(this.player, enabled);
    }

    protected void sync() {
    }

    @Override
    public boolean isEnabled() {
        return !this.abilitySources.isEmpty();
    }
}

