/*
 * Decompiled with CFR 0.152.
 */
package io.github.ladysnake.pal.impl;

import io.github.ladysnake.pal.PlayerAbility;
import io.github.ladysnake.pal.SimpleAbilityTracker;
import io.github.ladysnake.pal.impl.PalInternals;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_640;
import org.jetbrains.annotations.Contract;

public final class VanillaAbilityTracker
extends SimpleAbilityTracker {
    private final AbilitySetter setter;
    private final Predicate<class_1656> getter;

    public VanillaAbilityTracker(PlayerAbility abilityId, class_1657 player, AbilitySetter setter, Predicate<class_1656> getter) {
        super(abilityId, player);
        this.setter = setter;
        this.getter = getter;
    }

    @Override
    protected void updateState(boolean enabled) {
        super.updateState(enabled);
        this.updateBacking(enabled);
    }

    private void updateBacking(boolean enabled) {
        this.setter.set(VanillaAbilityTracker.getGamemode(this.player), this.player.method_31549(), enabled);
    }

    @Override
    protected void sync() {
        this.player.method_7355();
    }

    @Override
    public boolean isEnabled() {
        return this.getter.test(this.player.method_31549());
    }

    public void checkConflict() {
        boolean enabled = this.isEnabled();
        this.updateBacking(this.shouldBeEnabled());
        boolean expected = this.isEnabled();
        if (enabled != expected) {
            this.updateState(true);
            PalInternals.logTamperWarning(this.ability, enabled, expected);
        }
    }

    private static class_1934 getGamemode(class_1657 player) {
        if (player.method_73183().method_8608()) {
            class_640 playerListEntry = Objects.requireNonNull(class_310.method_1551().method_1562()).method_2871(player.method_7334().id());
            return playerListEntry != null ? playerListEntry.method_2958() : class_1934.field_9215;
        }
        return ((class_3222)player).field_13974.method_14257();
    }

    @FunctionalInterface
    public static interface AbilitySetter {
        @Contract(mutates="param2")
        public void set(class_1934 var1, class_1656 var2, boolean var3);
    }
}

