/*
 * Decompiled with CFR 0.152.
 */
package io.github.ladysnake.pal.impl.mixin;

import com.mojang.authlib.GameProfile;
import io.github.ladysnake.pal.AbilityTracker;
import io.github.ladysnake.pal.PlayerAbility;
import io.github.ladysnake.pal.VanillaAbilities;
import io.github.ladysnake.pal.impl.PalInternals;
import io.github.ladysnake.pal.impl.PlayerAbilityView;
import io.github.ladysnake.pal.impl.VanillaAbilityTracker;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_8791;
import net.minecraft.class_8942;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657
implements PlayerAbilityView {
    @Unique
    private final Map<PlayerAbility, AbilityTracker> palAbilities = new LinkedHashMap<PlayerAbility, AbilityTracker>();

    public ServerPlayerEntityMixin(class_1937 world, GameProfile gameProfile) {
        super(world, gameProfile);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(MinecraftServer server, class_3218 world, GameProfile profile, class_8791 clientOptions, CallbackInfo ci) {
        PalInternals.populate(this, this.palAbilities);
    }

    @Override
    public Iterable<PlayerAbility> listPalAbilities() {
        return this.palAbilities.keySet();
    }

    @Override
    public AbilityTracker get(PlayerAbility abilityId) {
        return this.palAbilities.get(abilityId);
    }

    @Override
    public void refreshAllPalAbilities(boolean syncVanilla) {
        for (PlayerAbility ability : this.listPalAbilities()) {
            if (ability == VanillaAbilities.FLYING) continue;
            this.get(ability).refresh(false);
        }
        if (syncVanilla) {
            this.method_7355();
        }
    }

    @Inject(method={"copyFrom"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerInteractionManager;setGameMode(Lnet/minecraft/world/GameMode;Lnet/minecraft/world/GameMode;)V", shift=At.Shift.AFTER)})
    private void copyAbilitiesAfterRespawn(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        if (alive) {
            class_11362 writeView = class_11362.method_71459((class_8942)class_8942.field_60348, (class_7225.class_7874)oldPlayer.method_56673());
            ((ServerPlayerEntityMixin)oldPlayer).writeAbilitiesToData((class_11372)writeView, null);
            this.readAbilitiesFromData(class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)oldPlayer.method_56673(), (class_2487)writeView.method_71475()), null);
        }
    }

    @Inject(method={"sendAbilitiesUpdate"}, at={@At(value="NEW", target="(Lnet/minecraft/entity/player/PlayerAbilities;)Lnet/minecraft/network/packet/s2c/play/PlayerAbilitiesS2CPacket;")})
    private void checkAbilityConsistency(CallbackInfo ci) {
        for (PlayerAbility ability : this.listPalAbilities()) {
            AbilityTracker tracker = this.get(ability);
            if (!(tracker instanceof VanillaAbilityTracker) || ability == VanillaAbilities.FLYING) continue;
            ((VanillaAbilityTracker)tracker).checkConflict();
        }
    }

    @Inject(method={"writeCustomData"}, at={@At(value="RETURN")})
    private void writeAbilitiesToData(class_11372 view, CallbackInfo ci) {
        class_11372.class_11374 list = view.method_71476("playerabilitylib:abilities");
        for (Map.Entry<PlayerAbility, AbilityTracker> entry : this.palAbilities.entrySet()) {
            class_11372 abilityTag = list.method_71480();
            abilityTag.method_71469("ability_id", entry.getKey().getId().toString());
            entry.getValue().save(abilityTag);
        }
    }

    @Inject(method={"readCustomData"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;readCustomData(Lnet/minecraft/storage/ReadView;)V", shift=At.Shift.AFTER)})
    private void readAbilitiesFromData(class_11368 view, CallbackInfo ci) {
        for (class_11368 abilityTag : view.method_71438("playerabilitylib:abilities")) {
            String abilityId = abilityTag.method_71428("ability_id", "");
            if (abilityId.isEmpty()) continue;
            AbilityTracker tracker = this.palAbilities.get(PalInternals.getAbility(class_2960.method_12829((String)abilityId)));
            if (tracker != null) {
                tracker.load(abilityTag);
                continue;
            }
            PalInternals.LOGGER.warn("Encountered unknown ability {} while deserializing data for {}", (Object)abilityId, (Object)this);
        }
    }
}

