/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.fantasy;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5217;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.nucleoid.fantasy.RuntimeWorld;
import xyz.nucleoid.fantasy.RuntimeWorldConfig;
import xyz.nucleoid.fantasy.RuntimeWorldHandle;
import xyz.nucleoid.fantasy.RuntimeWorldManager;
import xyz.nucleoid.fantasy.mixin.MinecraftServerAccess;

public final class Fantasy {
    public static final Logger LOGGER = LogManager.getLogger(Fantasy.class);
    public static final String ID = "fantasy";
    public static final class_5321<class_2874> DEFAULT_DIM_TYPE = class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)class_2960.method_60655((String)"fantasy", (String)"default"));
    private static Fantasy instance;
    private final MinecraftServer server;
    private final MinecraftServerAccess serverAccess;
    private final RuntimeWorldManager worldManager;
    private final Set<class_3218> deletionQueue = new ReferenceOpenHashSet();
    private final Set<class_3218> unloadingQueue = new ReferenceOpenHashSet();

    private Fantasy(MinecraftServer server) {
        this.server = server;
        this.serverAccess = (MinecraftServerAccess)server;
        this.worldManager = new RuntimeWorldManager(server);
    }

    public static Fantasy get(MinecraftServer server) {
        Preconditions.checkState((boolean)server.method_18854(), (Object)"cannot create worlds from off-thread!");
        if (instance == null || Fantasy.instance.server != server) {
            instance = new Fantasy(server);
        }
        return instance;
    }

    private void tick() {
        Set<class_3218> unloadingQueue;
        Set<class_3218> deletionQueue = this.deletionQueue;
        if (!deletionQueue.isEmpty()) {
            deletionQueue.removeIf(this::tickDeleteWorld);
        }
        if (!(unloadingQueue = this.unloadingQueue).isEmpty()) {
            unloadingQueue.removeIf(this::tickUnloadWorld);
        }
    }

    public RuntimeWorldHandle openTemporaryWorld(RuntimeWorldConfig config) {
        return this.openTemporaryWorld(Fantasy.generateTemporaryWorldKey(), config);
    }

    public RuntimeWorldHandle openTemporaryWorld(class_2960 key, RuntimeWorldConfig config) {
        RuntimeWorld world = this.addTemporaryWorld(key, config);
        return new RuntimeWorldHandle(this, world);
    }

    public RuntimeWorldHandle getOrOpenPersistentWorld(class_2960 key, RuntimeWorldConfig config) {
        class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)key);
        class_3218 world = this.server.method_3847(worldKey);
        if (world == null) {
            world = this.addPersistentWorld(key, config);
        } else {
            this.deletionQueue.remove(world);
            this.unloadingQueue.remove(world);
        }
        return new RuntimeWorldHandle(this, world);
    }

    private RuntimeWorld addPersistentWorld(class_2960 key, RuntimeWorldConfig config) {
        class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)key);
        return this.worldManager.add((class_5321<class_1937>)worldKey, config, RuntimeWorld.Style.PERSISTENT);
    }

    private RuntimeWorld addTemporaryWorld(class_2960 key, RuntimeWorldConfig config) {
        class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)key);
        try {
            class_32.class_5143 session = this.serverAccess.getSession();
            FileUtils.forceDeleteOnExit((File)session.method_27424(worldKey).toFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.worldManager.add((class_5321<class_1937>)worldKey, config, RuntimeWorld.Style.TEMPORARY);
    }

    void enqueueWorldDeletion(class_3218 world) {
        this.server.execute(() -> {
            world.method_14178().method_66012();
            world.field_13957 = true;
            this.kickPlayers(world);
            this.deletionQueue.add(world);
        });
    }

    void enqueueWorldUnloading(class_3218 world) {
        this.server.execute(() -> {
            world.field_13957 = false;
            world.method_14178().method_66012();
            world.method_14178().method_12127(() -> true, false);
            this.kickPlayers(world);
            this.unloadingQueue.add(world);
        });
    }

    public boolean tickDeleteWorld(class_3218 world) {
        this.kickPlayers(world);
        this.worldManager.delete(world);
        return true;
    }

    public boolean tickUnloadWorld(class_3218 world) {
        if (this.isWorldActive(world) && !world.method_14178().field_17254.method_39992()) {
            this.worldManager.unload(world);
            return true;
        }
        this.kickPlayers(world);
        return false;
    }

    private void kickPlayers(class_3218 world) {
        if (world.method_18456().isEmpty()) {
            return;
        }
        class_3218 spawnWorld = this.server.method_74944();
        class_5217.class_12064 spawnPoint = this.server.method_74945();
        ArrayList players = new ArrayList(world.method_18456());
        for (class_3222 player : players) {
            class_243 pos = player.method_14245(spawnWorld, spawnPoint.method_74897()).method_61082();
            class_5454 target = new class_5454(spawnWorld, pos, class_243.field_1353, spawnPoint.comp_4916(), spawnPoint.comp_4917(), class_5454.field_52245);
            player.method_61275(target);
        }
    }

    private boolean isWorldActive(class_3218 world) {
        return world.method_18456().isEmpty() && world.method_14178().method_14151() <= 0;
    }

    private void onServerStopping() {
        List<RuntimeWorld> temporaryWorlds = this.collectTemporaryWorlds();
        for (RuntimeWorld temporary : temporaryWorlds) {
            this.kickPlayers(temporary);
            this.worldManager.delete(temporary);
        }
    }

    private List<RuntimeWorld> collectTemporaryWorlds() {
        ArrayList<RuntimeWorld> temporaryWorlds = new ArrayList<RuntimeWorld>();
        for (class_3218 world : this.server.method_3738()) {
            if (!(world instanceof RuntimeWorld)) continue;
            RuntimeWorld runtimeWorld = (RuntimeWorld)world;
            if (runtimeWorld.style != RuntimeWorld.Style.TEMPORARY) continue;
            temporaryWorlds.add(runtimeWorld);
        }
        return temporaryWorlds;
    }

    private static class_2960 generateTemporaryWorldKey() {
        String key = RandomStringUtils.random((int)16, (String)"abcdefghijklmnopqrstuvwxyz0123456789");
        return class_2960.method_60655((String)ID, (String)key);
    }

    static {
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            Fantasy fantasy = Fantasy.get(server);
            fantasy.tick();
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            Fantasy fantasy = Fantasy.get(server);
            fantasy.onServerStopping();
        });
    }
}

