/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.fantasy;

import com.google.common.base.Preconditions;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_12279;
import net.minecraft.class_1267;
import net.minecraft.class_1928;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.fantasy.Fantasy;
import xyz.nucleoid.fantasy.RuntimeWorld;
import xyz.nucleoid.fantasy.util.GameRuleStore;

public final class RuntimeWorldConfig {
    private long seed = 0L;
    private class_5321<class_2874> dimensionTypeKey = Fantasy.DEFAULT_DIM_TYPE;
    private class_6880<class_2874> dimensionType;
    private class_2794 generator = null;
    private boolean shouldTickTime = false;
    private long timeOfDay = 6000L;
    private class_1267 difficulty = class_1267.field_5802;
    private final GameRuleStore gameRules = new GameRuleStore();
    private boolean mirrorOverworldGameRules = false;
    private boolean mirrorOverworldDifficulty = false;
    private RuntimeWorld.Constructor worldConstructor = RuntimeWorld::new;
    private int sunnyTime = Integer.MAX_VALUE;
    private boolean raining;
    private int rainTime;
    private boolean thundering;
    private int thunderTime;
    private TriState flat = TriState.DEFAULT;

    public RuntimeWorldConfig setSeed(long seed) {
        this.seed = seed;
        return this;
    }

    public RuntimeWorldConfig setWorldConstructor(RuntimeWorld.Constructor constructor) {
        this.worldConstructor = constructor;
        return this;
    }

    public RuntimeWorldConfig setDimensionType(class_6880<class_2874> dimensionType) {
        this.dimensionType = dimensionType;
        this.dimensionTypeKey = null;
        return this;
    }

    @Deprecated
    public RuntimeWorldConfig setDimensionType(class_2874 dimensionType) {
        this.dimensionType = class_6880.method_40223((Object)dimensionType);
        this.dimensionTypeKey = null;
        return this;
    }

    public RuntimeWorldConfig setDimensionType(class_5321<class_2874> dimensionType) {
        this.dimensionTypeKey = dimensionType;
        this.dimensionType = null;
        return this;
    }

    public RuntimeWorldConfig setGenerator(class_2794 generator) {
        this.generator = generator;
        return this;
    }

    public RuntimeWorldConfig setShouldTickTime(boolean shouldTickTime) {
        this.shouldTickTime = shouldTickTime;
        this.gameRules.set(class_1928.field_19396, shouldTickTime);
        return this;
    }

    public RuntimeWorldConfig setTimeOfDay(long timeOfDay) {
        this.timeOfDay = timeOfDay;
        return this;
    }

    public RuntimeWorldConfig setDifficulty(class_1267 difficulty) {
        this.difficulty = difficulty;
        return this;
    }

    public <T> RuntimeWorldConfig setGameRule(class_12279<T> key, T value) {
        this.gameRules.set(key, value);
        return this;
    }

    public RuntimeWorldConfig setMirrorOverworldGameRules(boolean mirror) {
        this.mirrorOverworldGameRules = mirror;
        return this;
    }

    public RuntimeWorldConfig setMirrorOverworldDifficulty(boolean mirror) {
        this.mirrorOverworldDifficulty = mirror;
        return this;
    }

    public RuntimeWorldConfig setSunny(int sunnyTime) {
        this.sunnyTime = sunnyTime;
        this.raining = false;
        this.thundering = false;
        return this;
    }

    public RuntimeWorldConfig setRaining(int rainTime) {
        this.raining = rainTime > 0;
        this.rainTime = rainTime;
        return this;
    }

    public RuntimeWorldConfig setRaining(boolean raining) {
        this.raining = raining;
        return this;
    }

    public RuntimeWorldConfig setThundering(int thunderTime) {
        this.thundering = thunderTime > 0;
        this.thunderTime = thunderTime;
        return this;
    }

    public RuntimeWorldConfig setThundering(boolean thundering) {
        this.thundering = thundering;
        return this;
    }

    public RuntimeWorldConfig setFlat(TriState state) {
        this.flat = state;
        return this;
    }

    public RuntimeWorldConfig setFlat(boolean state) {
        return this.setFlat(TriState.of((boolean)state));
    }

    public long getSeed() {
        return this.seed;
    }

    public class_5363 createDimensionOptions(MinecraftServer server) {
        class_6880<class_2874> dimensionType = this.resolveDimensionType(server);
        return new class_5363(dimensionType, this.generator);
    }

    private class_6880<class_2874> resolveDimensionType(MinecraftServer server) {
        class_6880 dimensionType = this.dimensionType;
        if (dimensionType == null) {
            dimensionType = server.method_30611().method_30530(class_7924.field_41241).method_46746(this.dimensionTypeKey).orElse(null);
            Preconditions.checkNotNull((Object)dimensionType, (Object)("invalid dimension type " + String.valueOf(this.dimensionTypeKey)));
        }
        return dimensionType;
    }

    @Nullable
    public class_2794 getGenerator() {
        return this.generator;
    }

    public RuntimeWorld.Constructor getWorldConstructor() {
        return this.worldConstructor;
    }

    public boolean shouldTickTime() {
        return this.shouldTickTime;
    }

    public long getTimeOfDay() {
        return this.timeOfDay;
    }

    public class_1267 getDifficulty() {
        return this.difficulty;
    }

    public GameRuleStore getGameRules() {
        return this.gameRules;
    }

    public boolean shouldMirrorOverworldGameRules() {
        return this.mirrorOverworldGameRules;
    }

    public boolean shouldMirrorOverworldDifficulty() {
        return this.mirrorOverworldDifficulty;
    }

    public int getSunnyTime() {
        return this.sunnyTime;
    }

    public int getRainTime() {
        return this.rainTime;
    }

    public int getThunderTime() {
        return this.thunderTime;
    }

    public boolean isRaining() {
        return this.raining;
    }

    public boolean isThundering() {
        return this.thundering;
    }

    public TriState isFlat() {
        return this.flat;
    }
}

